/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.nesscomputing.jackson.NessJacksonConfig;
import java.util.Map;
import java.util.Set;

class NessObjectMapperProvider
implements Provider<ObjectMapper> {
    private final Map<Enum<?>, Boolean> featureMap = Maps.newHashMap();
    private final Set<Module> modules = Sets.newHashSet();
    private final JsonFactory jsonFactory;

    @Inject
    NessObjectMapperProvider() {
        this(null);
    }

    NessObjectMapperProvider(JsonFactory jsonFactory) {
        this.jsonFactory = jsonFactory;
        this.featureMap.put(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.featureMap.put(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
        this.featureMap.put(SerializationFeature.FLUSH_AFTER_WRITE_VALUE, false);
        this.featureMap.put(MapperFeature.USE_GETTERS_AS_SETTERS, false);
    }

    @Inject(optional=true)
    void injectConfig(NessJacksonConfig config) {
        switch (config.getTimeFormat()) {
            case MILLIS: {
                this.featureMap.put(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, Boolean.TRUE);
                break;
            }
            case ISO8601: {
                this.featureMap.put(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, Boolean.FALSE);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown time format: " + (Object)((Object)config.getTimeFormat()));
            }
        }
    }

    @Inject(optional=true)
    void setSpecificSerializers(@Named(value="_jackson") Set<Module> modules) {
        this.modules.addAll(modules);
    }

    @Inject(optional=true)
    void setOptions(@Named(value="_jackson") Map<Enum<?>, Boolean> options) {
        this.featureMap.putAll(options);
    }

    @Override
    public ObjectMapper get() {
        ObjectMapper mapper = new ObjectMapper(this.jsonFactory);
        for (Map.Entry<Enum<?>, Boolean> entry : this.featureMap.entrySet()) {
            Enum<?> key = entry.getKey();
            if (key instanceof JsonGenerator.Feature) {
                mapper.configure((JsonGenerator.Feature)key, (boolean)entry.getValue());
                continue;
            }
            if (key instanceof JsonParser.Feature) {
                mapper.configure((JsonParser.Feature)key, (boolean)entry.getValue());
                continue;
            }
            if (key instanceof SerializationFeature) {
                mapper.configure((SerializationFeature)key, (boolean)entry.getValue());
                continue;
            }
            if (key instanceof DeserializationFeature) {
                mapper.configure((DeserializationFeature)key, (boolean)entry.getValue());
                continue;
            }
            if (key instanceof MapperFeature) {
                mapper.configure((MapperFeature)key, (boolean)entry.getValue());
                continue;
            }
            throw new IllegalArgumentException("Can not configure ObjectMapper with " + key.name());
        }
        for (Module module : this.modules) {
            mapper.registerModule(module);
        }
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return mapper;
    }
}

