/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.jackson;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.util.Types;
import com.nesscomputing.callback.Callback;
import com.nesscomputing.jackson.JacksonSerializerBinder;
import com.nesscomputing.jackson.JsonAutodetectDeserializer;
import com.nesscomputing.jackson.JsonDeserializerFunction;
import com.nesscomputing.jackson.JsonMapper;
import com.nesscomputing.jackson.JsonSerializerFunction;
import com.nesscomputing.jackson.SerializerBinderBuilder;
import com.nesscomputing.jackson.SmileDeserializerFunction;
import com.nesscomputing.jackson.SmileMapper;
import com.nesscomputing.jackson.SmileSerializerFunction;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

class SerializerBinderBuilderImpl<T>
implements SerializerBinderBuilder<T> {
    private static final TypeReference<byte[]> BYTEA_TYPE = new TypeReference<byte[]>(){};
    private static final TypeReference<String> STRING_TYPE = new TypeReference<String>(){};
    private final Binder binder;
    private final TypeReference<T> type;
    private Callback<Throwable> action = new Callback<Throwable>(){

        @Override
        public void call(Throwable item) throws Exception {
            throw Throwables.propagate(item);
        }
    };

    SerializerBinderBuilderImpl(Binder binder, TypeReference<T> type) {
        this.binder = binder;
        this.type = type;
    }

    @Override
    public SerializerBinderBuilder<T> onError(Callback<Throwable> action) {
        this.action = action;
        return this;
    }

    @Override
    public void bind() {
        this.binder.install(new BindingModule());
    }

    static class AutodetectDeserializerProvider<T>
    implements Provider<Function<byte[], T>>,
    Function<byte[], T> {
        private final Function<byte[], T> bytesProviderJson;
        private final Function<byte[], T> bytesProviderSmile;

        AutodetectDeserializerProvider(SerializerProvider<byte[], T> bytesProviderJson, SerializerProvider<byte[], T> bytesProviderSmile) {
            this.bytesProviderJson = bytesProviderJson.get();
            this.bytesProviderSmile = bytesProviderSmile.get();
        }

        @Override
        public Function<byte[], T> get() {
            return this;
        }

        @Override
        public T apply(byte[] input2) {
            if (input2.length > 0 && input2[0] == 58) {
                return this.bytesProviderSmile.apply(input2);
            }
            return this.bytesProviderJson.apply(input2);
        }
    }

    static class JsonBytesDeserializerProvider<T>
    extends SerializerProvider<byte[], T> {
        private final TypeReference<T> type;
        private ObjectMapper mapper;

        JsonBytesDeserializerProvider(TypeReference<T> type, Callback<Throwable> action) {
            super(action);
            this.type = type;
        }

        @Inject
        void setObjectMapper(@JsonMapper ObjectMapper mapper) {
            this.mapper = mapper;
        }

        @Override
        protected T serialize(byte[] input2) throws Exception {
            return this.mapper.readValue(input2, this.type);
        }
    }

    static class SmileDeserializerProvider<T>
    extends SerializerProvider<byte[], T> {
        private final TypeReference<T> type;
        private ObjectMapper mapper;

        SmileDeserializerProvider(TypeReference<T> type, Callback<Throwable> action) {
            super(action);
            this.type = type;
        }

        @Inject
        void setObjectMapper(@SmileMapper ObjectMapper mapper) {
            this.mapper = mapper;
        }

        @Override
        protected T serialize(byte[] input2) throws Exception {
            return this.mapper.readValue(input2, this.type);
        }
    }

    static class StringDeserializerProvider<T>
    extends SerializerProvider<String, T> {
        private final TypeReference<T> type;
        private ObjectMapper mapper;

        StringDeserializerProvider(TypeReference<T> type, Callback<Throwable> action) {
            super(action);
            this.type = type;
        }

        @Inject
        void setObjectMapper(@JsonMapper ObjectMapper mapper) {
            this.mapper = mapper;
        }

        @Override
        protected T serialize(String input2) throws Exception {
            return this.mapper.readValue(input2, this.type);
        }
    }

    static class JsonBytesSerializerProvider<T>
    extends SerializerProvider<T, byte[]> {
        private ObjectMapper mapper;

        JsonBytesSerializerProvider(Callback<Throwable> action) {
            super(action);
        }

        @Inject
        void setObjectMapper(@JsonMapper ObjectMapper mapper) {
            this.mapper = mapper;
        }

        @Override
        protected byte[] serialize(T input2) throws Exception {
            return this.mapper.writeValueAsBytes(input2);
        }
    }

    static class SmileSerializerProvider<T>
    extends SerializerProvider<T, byte[]> {
        private ObjectMapper mapper;

        SmileSerializerProvider(Callback<Throwable> action) {
            super(action);
        }

        @Inject
        void setObjectMapper(@SmileMapper ObjectMapper mapper) {
            this.mapper = mapper;
        }

        @Override
        protected byte[] serialize(T input2) throws Exception {
            return this.mapper.writeValueAsBytes(input2);
        }
    }

    static class StringSerializerProvider<T>
    extends SerializerProvider<T, String> {
        private ObjectMapper mapper;

        StringSerializerProvider(Callback<Throwable> action) {
            super(action);
        }

        @Inject
        void setObjectMapper(@JsonMapper ObjectMapper mapper) {
            this.mapper = mapper;
        }

        @Override
        protected String serialize(T input2) throws Exception {
            return this.mapper.writeValueAsString(input2);
        }
    }

    static abstract class SerializerProvider<In, Out>
    implements Provider<Function<In, Out>> {
        private final Callback<Throwable> action;

        SerializerProvider(Callback<Throwable> action) {
            this.action = action;
        }

        protected abstract Out serialize(In var1) throws Exception;

        @Override
        public Function<In, Out> get() {
            return new Function<In, Out>(){

                @Override
                public Out apply(In input2) {
                    try {
                        return SerializerProvider.this.serialize(input2);
                    }
                    catch (Exception e) {
                        try {
                            SerializerProvider.this.action.call(e);
                            return null;
                        }
                        catch (Exception e2) {
                            throw Throwables.propagate(e2);
                        }
                    }
                }
            };
        }
    }

    private class DeserializerModule
    extends AbstractModule {
        private DeserializerModule() {
        }

        @Override
        protected void configure() {
            this.bindDeserializers(JsonDeserializerFunction.class, SmileDeserializerFunction.class, true);
        }

        private void bindDeserializers(Class<? extends Annotation> jsonDeserializerAnnotation, Class<? extends Annotation> smileDeserializerAnnotation, boolean bindAuto) {
            StringDeserializerProvider stringProvider = new StringDeserializerProvider(SerializerBinderBuilderImpl.this.type, SerializerBinderBuilderImpl.this.action);
            SmileDeserializerProvider bytesProviderSmile = new SmileDeserializerProvider(SerializerBinderBuilderImpl.this.type, SerializerBinderBuilderImpl.this.action);
            JsonBytesDeserializerProvider bytesProviderJson = new JsonBytesDeserializerProvider(SerializerBinderBuilderImpl.this.type, SerializerBinderBuilderImpl.this.action);
            this.bind(JacksonSerializerBinder.keyFor(STRING_TYPE, SerializerBinderBuilderImpl.this.type, jsonDeserializerAnnotation)).toProvider(stringProvider).in(Scopes.SINGLETON);
            this.bind(Key.get(Types.newParameterizedType(Function.class, new Type[]{String.class, Types.subtypeOf(SerializerBinderBuilderImpl.this.type.getType()), jsonDeserializerAnnotation}))).toProvider(stringProvider).in(Scopes.SINGLETON);
            this.bind(JacksonSerializerBinder.keyFor(BYTEA_TYPE, SerializerBinderBuilderImpl.this.type, jsonDeserializerAnnotation)).toProvider(bytesProviderJson).in(Scopes.SINGLETON);
            this.bind(Key.get((Type)Types.newParameterizedType(Function.class, new Type[]{byte[].class, Types.subtypeOf(SerializerBinderBuilderImpl.this.type.getType())}), jsonDeserializerAnnotation)).toProvider(bytesProviderJson).in(Scopes.SINGLETON);
            this.bind(JacksonSerializerBinder.keyFor(BYTEA_TYPE, SerializerBinderBuilderImpl.this.type, smileDeserializerAnnotation)).toProvider(bytesProviderSmile).in(Scopes.SINGLETON);
            this.bind(Key.get((Type)Types.newParameterizedType(Function.class, new Type[]{byte[].class, Types.subtypeOf(SerializerBinderBuilderImpl.this.type.getType())}), smileDeserializerAnnotation)).toProvider(bytesProviderSmile).in(Scopes.SINGLETON);
            if (!bindAuto) {
                return;
            }
            AutodetectDeserializerProvider bytesProviderAuto = new AutodetectDeserializerProvider(bytesProviderJson, bytesProviderSmile);
            this.bind(JacksonSerializerBinder.keyFor(BYTEA_TYPE, SerializerBinderBuilderImpl.this.type, JsonAutodetectDeserializer.class)).toProvider(bytesProviderAuto).in(Scopes.SINGLETON);
            this.bind(Key.get((Type)Types.newParameterizedType(Function.class, new Type[]{byte[].class, Types.subtypeOf(SerializerBinderBuilderImpl.this.type.getType())}), JsonAutodetectDeserializer.class)).toProvider(bytesProviderAuto).in(Scopes.SINGLETON);
        }
    }

    private class SerializerModule
    extends AbstractModule {
        private SerializerModule() {
        }

        @Override
        protected void configure() {
            this.bindSerializers(JsonSerializerFunction.class, SmileSerializerFunction.class);
        }

        private void bindSerializers(Class<? extends Annotation> jsonSerializerAnnotation, Class<? extends Annotation> smileSerializerAnnotation) {
            StringSerializerProvider stringProvider = new StringSerializerProvider(SerializerBinderBuilderImpl.this.action);
            SmileSerializerProvider bytesProviderSmile = new SmileSerializerProvider(SerializerBinderBuilderImpl.this.action);
            JsonBytesSerializerProvider bytesProviderJson = new JsonBytesSerializerProvider(SerializerBinderBuilderImpl.this.action);
            this.bind(JacksonSerializerBinder.keyFor(SerializerBinderBuilderImpl.this.type, STRING_TYPE, jsonSerializerAnnotation)).toProvider(stringProvider).in(Scopes.SINGLETON);
            this.bind(Key.get((Type)Types.newParameterizedType(Function.class, new Type[]{Types.supertypeOf(SerializerBinderBuilderImpl.this.type.getType()), String.class}), jsonSerializerAnnotation)).toProvider(stringProvider).in(Scopes.SINGLETON);
            this.bind(JacksonSerializerBinder.keyFor(SerializerBinderBuilderImpl.this.type, BYTEA_TYPE, jsonSerializerAnnotation)).toProvider(bytesProviderJson).in(Scopes.SINGLETON);
            this.bind(Key.get((Type)Types.newParameterizedType(Function.class, new Type[]{Types.supertypeOf(SerializerBinderBuilderImpl.this.type.getType()), byte[].class}), jsonSerializerAnnotation)).toProvider(bytesProviderJson).in(Scopes.SINGLETON);
            this.bind(JacksonSerializerBinder.keyFor(SerializerBinderBuilderImpl.this.type, BYTEA_TYPE, smileSerializerAnnotation)).toProvider(bytesProviderSmile).in(Scopes.SINGLETON);
            this.bind(Key.get((Type)Types.newParameterizedType(Function.class, new Type[]{Types.supertypeOf(SerializerBinderBuilderImpl.this.type.getType()), byte[].class}), smileSerializerAnnotation)).toProvider(bytesProviderSmile).in(Scopes.SINGLETON);
        }
    }

    private class BindingModule
    extends AbstractModule {
        private BindingModule() {
        }

        @Override
        protected void configure() {
            this.install(new SerializerModule());
            this.install(new DeserializerModule());
        }

        SerializerBinderBuilderImpl<?> getOuter() {
            return SerializerBinderBuilderImpl.this;
        }

        public int hashCode() {
            return new HashCodeBuilder().append(SerializerBinderBuilderImpl.this.type.getType()).toHashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BindingModule)) {
                return false;
            }
            BindingModule other = (BindingModule)obj;
            return new EqualsBuilder().append(SerializerBinderBuilderImpl.this.type.getType(), ((SerializerBinderBuilderImpl)other.getOuter()).type.getType()).isEquals();
        }
    }
}

