/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.jackson.datatype;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;

class MapEntryModule
extends Module {
    MapEntryModule() {
    }

    @Override
    public String getModuleName() {
        return "Map.Entry module";
    }

    @Override
    public Version version() {
        return Version.unknownVersion();
    }

    @Override
    public void setupModule(Module.SetupContext context) {
        context.addDeserializers(new MapEntryDeserializers());
    }

    private static class MapEntryDeserializer
    extends JsonDeserializer<Map.Entry<?, ?>> {
        private final JavaType type;

        MapEntryDeserializer(JavaType type) {
            this.type = type;
            Preconditions.checkArgument(type.containedTypeCount() == 2, "Map.Entry has exactly 2 child types");
        }

        @Override
        public Map.Entry<?, ?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonToken nextToken;
            JsonDeserializer<Object> deserK = ctxt.findContextualValueDeserializer(this.type.containedType(0), null);
            JsonDeserializer<Object> deserV = ctxt.findContextualValueDeserializer(this.type.containedType(1), null);
            Object k = null;
            Object v = null;
            if (!jp.hasCurrentToken() || jp.getCurrentToken() != JsonToken.START_OBJECT) {
                this.expect(jp.nextToken(), JsonToken.START_OBJECT, jp, ctxt);
            }
            while ((nextToken = jp.nextToken()) != JsonToken.END_OBJECT) {
                this.expect(nextToken, JsonToken.FIELD_NAME, jp, ctxt);
                jp.nextToken();
                if ("key".equals(jp.getCurrentName())) {
                    k = deserK.deserialize(jp, ctxt);
                    continue;
                }
                if ("value".equals(jp.getCurrentName())) {
                    v = deserV.deserialize(jp, ctxt);
                    continue;
                }
                if (ctxt.handleUnknownProperty(jp, this, Map.Entry.class, jp.getCurrentName())) continue;
                throw new JsonMappingException("Unknown Map.Entry property " + jp.getCurrentName(), jp.getCurrentLocation());
            }
            return Maps.immutableEntry(k, v);
        }

        private void expect(JsonToken actual, JsonToken expected, JsonParser jp, DeserializationContext ctxt) throws JsonMappingException {
            if (actual != expected) {
                throw ctxt.wrongTokenException(jp, expected, "Wrong token");
            }
        }
    }

    private static class MapEntryDeserializers
    extends Deserializers.Base {
        private MapEntryDeserializers() {
        }

        @Override
        public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
            if (type.getRawClass().equals(Map.Entry.class)) {
                return new MapEntryDeserializer(type);
            }
            return null;
        }
    }
}

