/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.jmx.jolokia;

import com.google.common.collect.Maps;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.name.Names;
import com.google.inject.servlet.ServletModule;
import com.nesscomputing.config.Config;
import com.nesscomputing.config.ConfigProvider;
import com.nesscomputing.jmx.jolokia.JolokiaConfig;
import com.nesscomputing.jmx.jolokia.JolokiaServlet;
import com.nesscomputing.jmx.jolokia.NoJolokiaServlet;
import com.nesscomputing.lifecycle.Lifecycle;
import com.nesscomputing.lifecycle.LifecycleListener;
import com.nesscomputing.lifecycle.LifecycleStage;
import com.nesscomputing.logging.Log;
import java.lang.annotation.Annotation;
import java.util.EnumMap;
import javax.servlet.http.HttpServlet;
import org.apache.commons.configuration.AbstractConfiguration;
import org.jolokia.backend.BackendManager;
import org.jolokia.http.HttpRequestHandler;
import org.jolokia.restrictor.AllowAllRestrictor;
import org.jolokia.restrictor.Restrictor;
import org.jolokia.util.ConfigKey;
import org.jolokia.util.LogHandler;

public class JolokiaModule
extends ServletModule {
    static final Annotation JOLOKIA_SERVLET = Names.named("_jolokiaServlet");

    @Override
    public void configureServlets() {
        this.bind(JolokiaConfig.class).toProvider(ConfigProvider.of(JolokiaConfig.class));
        this.bind(HttpServlet.class).annotatedWith(JOLOKIA_SERVLET).toProvider(JolokiaServletProvider.class).in(Scopes.SINGLETON);
        this.serve("/jolokia/*", new String[0]).with(Key.get(HttpServlet.class, JOLOKIA_SERVLET));
        this.configureRestrictor();
    }

    protected void configureRestrictor() {
        this.bind(Restrictor.class).to(AllowAllRestrictor.class).in(Scopes.SINGLETON);
    }

    private static class RealJolokiaModule
    extends AbstractModule {
        private RealJolokiaModule() {
        }

        @Override
        protected void configure() {
            this.bind(JolokiaServlet.class);
        }

        @Provides
        @Singleton
        BackendManager getBackendManager(Config config, LogHandler logHandler, Restrictor restrictor, Lifecycle lifecycle) {
            AbstractConfiguration jolokiaConfig = config.getConfiguration("ness.jolokia");
            EnumMap<ConfigKey, String> configMap = Maps.newEnumMap(ConfigKey.class);
            for (ConfigKey key : ConfigKey.values()) {
                if (!key.isGlobalConfig()) continue;
                configMap.put(key, jolokiaConfig.getString(key.getKeyValue(), key.getDefaultValue()));
            }
            final BackendManager backendManager = new BackendManager(configMap, logHandler, restrictor);
            lifecycle.addListener(LifecycleStage.STOP_STAGE, new LifecycleListener(){

                @Override
                public void onStage(LifecycleStage lifecycleStage) {
                    backendManager.destroy();
                }
            });
            return backendManager;
        }

        @Provides
        @Singleton
        HttpRequestHandler getHttpRequestHandler(LogHandler logHandler, BackendManager backendManager) {
            return new HttpRequestHandler(backendManager, logHandler);
        }

        @Provides
        @Singleton
        LogHandler getLogHandler() {
            final Log jolokiaLog = Log.forName("jolokia");
            return new LogHandler(){

                @Override
                public void debug(String message) {
                    jolokiaLog.debug(message);
                }

                @Override
                public void info(String message) {
                    jolokiaLog.info(message);
                }

                @Override
                public void error(String message, Throwable t) {
                    jolokiaLog.error(t, message);
                }
            };
        }
    }

    static class JolokiaServletProvider
    implements Provider<HttpServlet> {
        private final JolokiaConfig config;
        private final Injector injector;

        @Inject
        JolokiaServletProvider(JolokiaConfig config, Injector injector) {
            this.config = config;
            this.injector = injector;
        }

        @Override
        public HttpServlet get() {
            if (this.config.isJolokiaEnabled()) {
                return this.injector.createChildInjector(new RealJolokiaModule()).getInstance(JolokiaServlet.class);
            }
            return new NoJolokiaServlet();
        }
    }
}

