/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.jmx.jolokia;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.PrintWriter;
import javax.management.RuntimeMBeanException;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jolokia.backend.BackendManager;
import org.jolokia.http.HttpRequestHandler;
import org.jolokia.util.ConfigKey;
import org.json.simple.JSONAware;

@Singleton
public class JolokiaServlet
extends HttpServlet {
    private static final long serialVersionUID = 42L;
    private final transient ServletRequestHandler httpGetHandler;
    private final transient ServletRequestHandler httpPostHandler;
    private final transient BackendManager backendManager;
    private final transient HttpRequestHandler requestHandler;

    @Inject
    public JolokiaServlet(BackendManager backendManager, HttpRequestHandler requestHandler) {
        this.backendManager = backendManager;
        this.requestHandler = requestHandler;
        this.httpGetHandler = new HttpGetHandler();
        this.httpPostHandler = new HttpPostHandler();
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handle(this.httpGetHandler, req, resp);
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handle(this.httpPostHandler, req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handle(ServletRequestHandler reqHandler, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        JSONAware json = null;
        try {
            this.requestHandler.checkClientIPAccess(req.getRemoteHost(), req.getRemoteAddr());
            json = reqHandler.handleRequest(req, resp);
            if (this.backendManager.isDebug()) {
                this.backendManager.debug("Response: " + json);
            }
        }
        catch (RuntimeMBeanException rme) {
            json = this.requestHandler.handleThrowable(rme.getTargetException());
        }
        catch (Throwable exp) {
            json = this.requestHandler.handleThrowable(exp);
        }
        finally {
            String callback = req.getParameter(ConfigKey.CALLBACK.getKeyValue());
            if (callback != null) {
                this.sendResponse(resp, "text/javascript", callback + "(" + json.toJSONString() + ");");
            } else {
                this.sendResponse(resp, "application/json", json.toJSONString());
            }
        }
    }

    private void sendResponse(HttpServletResponse resp, String contentType, String jsonTxt) throws IOException {
        resp.setCharacterEncoding("utf-8");
        resp.addHeader("Access-Control-Allow-Origin", "*");
        resp.setContentType(contentType);
        resp.setStatus(200);
        PrintWriter writer = resp.getWriter();
        writer.write(jsonTxt);
        writer.flush();
    }

    private final class HttpGetHandler
    implements ServletRequestHandler {
        private HttpGetHandler() {
        }

        @Override
        public JSONAware handleRequest(HttpServletRequest req, HttpServletResponse resp) {
            return JolokiaServlet.this.requestHandler.handleGetRequest(req.getRequestURI(), req.getPathInfo(), req.getParameterMap());
        }
    }

    private final class HttpPostHandler
    implements ServletRequestHandler {
        private HttpPostHandler() {
        }

        @Override
        public JSONAware handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
            String encoding = req.getCharacterEncoding();
            ServletInputStream is = req.getInputStream();
            return JolokiaServlet.this.requestHandler.handlePostRequest(req.getRequestURI(), is, encoding, req.getParameterMap());
        }
    }

    private static interface ServletRequestHandler {
        public JSONAware handleRequest(HttpServletRequest var1, HttpServletResponse var2) throws IOException;
    }
}

