/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.jmx.starter;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.nesscomputing.jmx.starter.JmxExporterConfig;
import com.nesscomputing.jmx.starter.JmxSocketFactory;
import com.nesscomputing.jmx.starter.guice.IOExceptionProvider;
import com.nesscomputing.lifecycle.guice.OnStage;
import com.nesscomputing.logging.Log;
import java.io.IOException;
import java.net.MalformedURLException;
import java.rmi.registry.LocateRegistry;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;

public class JmxExporter {
    private static final Log LOG = Log.findLog();
    private final JMXServiceURL url;
    private final JMXConnectorServer connectorServer;
    private final JmxExporterConfig config;

    @Inject
    public JmxExporter(MBeanServer server, IOExceptionProvider<JmxExporterConfig> configProvider, @Named(value="_jmxStarter") Map<String, String> env) throws IOException {
        this.config = configProvider.get();
        try {
            String hostName = this.config.getHostname().getHostAddress();
            this.url = new JMXServiceURL(String.format("service:jmx:rmi://%s:%d/jndi/rmi://%s:%d/jmxrmi", hostName, this.config.getRmiServerPort(), hostName, this.config.getRmiRegistryPort()));
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
        this.connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(this.url, env, server);
    }

    public JMXServiceURL getURL() {
        return this.url;
    }

    public boolean isActive() {
        return this.connectorServer.isActive();
    }

    @OnStage(value="start")
    public void start() throws IOException {
        System.setProperty("java.rmi.server.randomIDs", String.valueOf(this.config.useRandomIds()));
        System.setProperty("java.rmi.server.hostname", this.config.getHostname().getHostAddress());
        JmxSocketFactory factory = new JmxSocketFactory(this.config.getHostname());
        LocateRegistry.createRegistry(this.config.getRmiRegistryPort(), factory, factory);
        this.connectorServer.start();
        LOG.info("Started exporter on port %d", this.config.getRmiRegistryPort());
    }

    @OnStage(value="stop")
    public void stop() throws IOException {
        this.connectorServer.stop();
        LOG.info("Stopped exporter on port %d", this.config.getRmiRegistryPort());
    }
}

