/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.jmx.starter;

import com.nesscomputing.jmx.starter.NetUtils;
import java.io.IOException;
import java.net.InetAddress;

public final class JmxExporterConfig {
    private final InetAddress hostname;
    private final int rmiRegistryPort;
    private final int rmiServerPort;
    private final boolean useRandomIds;

    public static JmxExporterConfig defaultJmxExporterConfig(InetAddress hostname, Integer port) throws IOException {
        return JmxExporterConfig.defaultJmxExporterConfig(hostname, port, null, true);
    }

    public static JmxExporterConfig defaultJmxExporterConfig(InetAddress hostname, Integer rmiRegistryPort, Integer rmiServerPort, boolean useRandomIds) throws IOException {
        return new JmxExporterConfig(hostname != null ? hostname : InetAddress.getByName(null), rmiRegistryPort != null ? rmiRegistryPort : NetUtils.findUnusedPort(), rmiServerPort != null ? rmiServerPort : NetUtils.findUnusedPort(), useRandomIds);
    }

    public JmxExporterConfig(InetAddress hostname, int rmiRegistryPort, int rmiServerPort, boolean useRandomIds) {
        this.hostname = hostname;
        this.rmiRegistryPort = rmiRegistryPort;
        this.rmiServerPort = rmiServerPort;
        this.useRandomIds = useRandomIds;
    }

    public Integer getRmiRegistryPort() {
        return this.rmiRegistryPort;
    }

    public Integer getRmiServerPort() {
        return this.rmiServerPort;
    }

    public InetAddress getHostname() {
        return this.hostname;
    }

    public boolean useRandomIds() {
        return this.useRandomIds;
    }
}

