/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.jmx.starter.guice;

import com.google.inject.Inject;
import com.nesscomputing.galaxy.GalaxyConfig;
import com.nesscomputing.jmx.starter.JmxExporterConfig;
import com.nesscomputing.jmx.starter.NetUtils;
import com.nesscomputing.jmx.starter.guice.IOExceptionProvider;
import com.nesscomputing.jmx.starter.guice.JmxStarterConfig;
import java.io.IOException;
import java.net.InetAddress;
import org.apache.commons.lang3.ObjectUtils;

public class JmxExporterConfigProvider
implements IOExceptionProvider<JmxExporterConfig> {
    private final InetAddress configuredHost;
    private final Integer configuredPort;
    private InetAddress galaxyHost = null;
    private Integer galaxyPort = null;

    @Inject
    public JmxExporterConfigProvider(JmxStarterConfig jmxStarterConfig) throws IOException {
        this.configuredPort = jmxStarterConfig.getBindPort();
        this.configuredHost = jmxStarterConfig.getBindAddress() == null ? null : InetAddress.getByName(jmxStarterConfig.getBindAddress());
    }

    @Inject(optional=true)
    void injectGalaxyConfig(GalaxyConfig galaxyConfig) throws IOException {
        this.galaxyPort = galaxyConfig.getPrivate().getPortJmx() == 0 ? null : Integer.valueOf(galaxyConfig.getPrivate().getPortJmx());
        String host = galaxyConfig.getInternalIp().getIp();
        if (host != null) {
            this.galaxyHost = InetAddress.getByName(host);
        }
    }

    @Override
    public JmxExporterConfig get() throws IOException {
        Integer port = ObjectUtils.firstNonNull(this.galaxyPort, this.configuredPort, NetUtils.findUnusedPort());
        InetAddress hostAddr = ObjectUtils.firstNonNull(this.galaxyHost, this.configuredHost);
        return JmxExporterConfig.defaultJmxExporterConfig(hostAddr, port);
    }
}

