/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.jmx.starter.guice;

import com.google.common.collect.ImmutableMap;
import com.google.inject.AbstractModule;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.inject.throwingproviders.ThrowingProviderBinder;
import com.nesscomputing.config.Config;
import com.nesscomputing.jmx.starter.JmxExporter;
import com.nesscomputing.jmx.starter.JmxExporterConfig;
import com.nesscomputing.jmx.starter.guice.IOExceptionProvider;
import com.nesscomputing.jmx.starter.guice.JmxExporterConfigProvider;
import com.nesscomputing.jmx.starter.guice.JmxStarterConfig;
import com.nesscomputing.logging.Log;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class JmxStarterModule
extends AbstractModule {
    public static final String JMX_STARTER_NAME = "_jmxStarter";
    public static final Named JMX_STARTER_NAMED = Names.named("_jmxStarter");
    private static final Log LOG = Log.findLog();
    private final Config config;

    public JmxStarterModule(Config config) {
        this.config = config;
    }

    @Override
    public void configure() {
        JmxStarterConfig jmxStarterConfig = this.config.getBean(JmxStarterConfig.class);
        this.bind(JmxStarterConfig.class).toInstance(jmxStarterConfig);
        if (jmxStarterConfig.isEnabled()) {
            LOG.info("Exporting JMX...");
            ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
            if (StringUtils.isNotBlank(jmxStarterConfig.getPasswordFile())) {
                builder.put("jmx.remote.x.password.file", jmxStarterConfig.getPasswordFile());
            }
            if (StringUtils.isNotBlank(jmxStarterConfig.getAccessFile())) {
                builder.put("jmx.remote.x.access.file", jmxStarterConfig.getAccessFile());
            }
            builder.put("jmx.remote.x.daemon", "true");
            this.bind(new TypeLiteral<Map<String, String>>(){}).annotatedWith(JMX_STARTER_NAMED).toInstance(builder.build());
            this.bind(JmxExporterConfigProvider.class).in(Scopes.SINGLETON);
            ThrowingProviderBinder.create(this.binder()).bind(IOExceptionProvider.class, (Type)((Object)JmxExporterConfig.class)).to(JmxExporterConfigProvider.class).in(Scopes.SINGLETON);
            this.bind(JmxExporter.class).asEagerSingleton();
        } else {
            LOG.info("Not exporting JMX.");
        }
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass().equals(obj.getClass());
    }
}

