/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.lifecycle;

import com.google.common.collect.Lists;
import com.nesscomputing.lifecycle.Lifecycle;
import com.nesscomputing.lifecycle.LifecycleDriver;
import com.nesscomputing.lifecycle.LifecycleListener;
import com.nesscomputing.lifecycle.LifecycleStage;
import com.nesscomputing.logging.Log;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;

public abstract class AbstractLifecycle
implements Lifecycle {
    private static final Log LOG = Log.findLog();
    private final ConcurrentMap<LifecycleStage, List<LifecycleListener>> listeners = new ConcurrentHashMap<LifecycleStage, List<LifecycleListener>>();
    private final LifecycleDriver lifecycleDriver;
    private final boolean verbose;

    protected AbstractLifecycle(@Nonnull LifecycleDriver lifecycleDriver, boolean verbose) {
        this.verbose = verbose;
        this.lifecycleDriver = lifecycleDriver;
        for (LifecycleStage lifecycleStage : lifecycleDriver.getStages()) {
            this.listeners.put(lifecycleStage, new CopyOnWriteArrayList());
            this.addListener(lifecycleStage, lifecycleDriver);
        }
    }

    @Override
    public void addListener(@Nonnull LifecycleStage lifecycleStage, @Nonnull LifecycleListener lifecycleListener) {
        if (!this.listeners.containsKey(lifecycleStage)) {
            throw this.illegalStage(lifecycleStage);
        }
        ((List)this.listeners.get(lifecycleStage)).add(lifecycleListener);
    }

    @Override
    public LifecycleStage getNextStage() {
        return this.lifecycleDriver.getNextStage();
    }

    @Override
    public void executeNext() {
        LifecycleStage nextStage = this.getNextStage();
        if (nextStage == null) {
            throw new IllegalStateException("Lifecycle already hit the final stage!");
        }
        this.execute(nextStage);
    }

    @Override
    public void executeTo(@Nonnull LifecycleStage lifecycleStage) {
        boolean foundStage = false;
        do {
            LifecycleStage nextStage;
            if ((nextStage = this.lifecycleDriver.getNextStage()) == null) {
                throw new IllegalStateException("Never reached stage '" + lifecycleStage.getName() + "' before ending the lifecycle.");
            }
            foundStage = nextStage.equals(lifecycleStage);
            this.execute(nextStage);
        } while (!foundStage);
    }

    @Override
    public void execute(@Nonnull LifecycleStage lifecycleStage) {
        List<LifecycleListener> lifecycleListeners = (List<LifecycleListener>)this.listeners.get(lifecycleStage);
        if (lifecycleListeners == null) {
            throw this.illegalStage(lifecycleStage);
        }
        this.log("Stage '%s' starting...", lifecycleStage.getName());
        if (lifecycleStage.equals(LifecycleStage.STOP_STAGE)) {
            lifecycleListeners = Lists.reverse(lifecycleListeners);
        }
        for (LifecycleListener listener : lifecycleListeners) {
            listener.onStage(lifecycleStage);
        }
        this.log("Stage '%s' complete.", lifecycleStage.getName());
    }

    protected void join(final @Nonnull LifecycleStage lifecycleStage, final boolean cycle) throws InterruptedException {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (cycle) {
                    AbstractLifecycle.this.executeTo(lifecycleStage);
                } else {
                    AbstractLifecycle.this.execute(lifecycleStage);
                }
            }
        });
        Thread.currentThread().join();
    }

    protected IllegalStateException illegalStage(LifecycleStage lifecycleStage) {
        return new IllegalStateException(String.format("This lifecycle does not support the '%s' stage, only '%s' are supported", lifecycleStage.getName(), this.lifecycleDriver.getStages()));
    }

    protected void log(String message, Object ... args) {
        if (this.verbose) {
            LOG.info(message, args);
        } else {
            LOG.debug(message, args);
        }
    }
}

