/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.lifecycle;

import com.nesscomputing.lifecycle.LifecycleListener;
import com.nesscomputing.lifecycle.LifecycleStage;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class LifecycleDriver
implements LifecycleListener {
    private final LinkedList<LifecycleStage> lifecycleStages = new LinkedList();
    private final Map<LifecycleStage, LifecycleStage> stageMap = new HashMap<LifecycleStage, LifecycleStage>();
    private LifecycleStage nextStage = null;

    public LifecycleDriver(LifecycleStage ... stages) {
        for (LifecycleStage stage : stages) {
            if (this.lifecycleStages.size() > 0) {
                this.stageMap.put(this.lifecycleStages.getLast(), stage);
            }
            this.stageMap.put(stage, null);
            this.lifecycleStages.add(stage);
        }
        this.nextStage = this.lifecycleStages.getFirst();
    }

    public List<LifecycleStage> getStages() {
        return Collections.unmodifiableList(this.lifecycleStages);
    }

    public LifecycleStage getNextStage() {
        return this.nextStage;
    }

    @Override
    public void onStage(@Nonnull LifecycleStage stage) {
        if (!this.stageMap.containsKey(stage)) {
            throw new IllegalStateException("Stage '" + stage.getName() + "' is not in this lifecycle driver!");
        }
        this.nextStage = this.stageMap.get(stage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName()).append('[');
        Iterator it = this.lifecycleStages.iterator();
        while (it.hasNext()) {
            boolean ne;
            LifecycleStage le = (LifecycleStage)it.next();
            boolean bl = ne = this.nextStage != null && le.equals(this.nextStage);
            if (ne) {
                sb.append("*");
            }
            sb.append(le.getName());
            if (ne) {
                sb.append("*");
            }
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(']');
        return sb.toString();
    }
}

