/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.lifecycle.guice;

import com.google.inject.Inject;
import com.nesscomputing.lifecycle.Lifecycle;
import com.nesscomputing.lifecycle.LifecycleListener;
import com.nesscomputing.lifecycle.LifecycleStage;
import com.nesscomputing.lifecycle.guice.LifecycleAction;
import com.nesscomputing.lifecycle.guice.LifecycleProvider;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.builder.ToStringBuilder;

public abstract class AbstractLifecycleProvider<T>
implements LifecycleProvider<T> {
    private Lifecycle lifecycle = null;
    private final List<StageEvent> stageEvents = new ArrayList<StageEvent>();

    @Override
    public void addAction(LifecycleStage stage, LifecycleAction<T> action) {
        this.stageEvents.add(new StageEvent(stage, action));
    }

    @Inject(optional=true)
    public final void setLifecycle(Lifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    @Override
    public final T get() {
        T result2 = this.internalGet();
        if (this.lifecycle != null) {
            for (StageEvent stageEvent : this.stageEvents) {
                this.lifecycle.addListener(stageEvent.getLifecycleStage(), new ActionLifecycleListener(stageEvent.getLifecycleAction(), result2));
            }
        }
        return result2;
    }

    protected abstract T internalGet();

    public static class ActionLifecycleListener<T>
    implements LifecycleListener {
        private final LifecycleAction<T> action;
        private final T obj;

        private ActionLifecycleListener(@Nonnull LifecycleAction<T> action, @Nonnull T obj) {
            this.action = action;
            this.obj = obj;
        }

        @Override
        public void onStage(@Nonnull LifecycleStage stage) {
            this.action.performAction(this.obj);
        }
    }

    private class StageEvent {
        private final LifecycleStage stage;
        private final LifecycleAction<T> action;
        private transient String toString;

        private StageEvent(@Nonnull LifecycleStage stage, LifecycleAction<T> action) {
            this.stage = stage;
            this.action = action;
        }

        private LifecycleStage getLifecycleStage() {
            return this.stage;
        }

        private LifecycleAction<T> getLifecycleAction() {
            return this.action;
        }

        public String toString() {
            if (this.toString == null) {
                this.toString = new ToStringBuilder(this).append("stage", this.stage).append("action", this.action).toString();
            }
            return this.toString;
        }
    }
}

