/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.lifecycle.guice;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.nesscomputing.lifecycle.guice.AbstractLifecycleProvider;
import com.nesscomputing.lifecycle.guice.LifecycleProvider;
import javax.annotation.Nonnull;

public class DelegatingLifecycleProvider<T>
extends AbstractLifecycleProvider<T> {
    private final Class<? extends Provider<T>> providerClass;
    private Provider<T> delegate = null;

    public static final <U> LifecycleProvider<U> of(@Nonnull Class<? extends Provider<U>> providerClass) {
        return new DelegatingLifecycleProvider(providerClass, null);
    }

    public static final <U> LifecycleProvider<U> of(@Nonnull Provider<U> delegate) {
        return new DelegatingLifecycleProvider<U>(null, delegate);
    }

    private DelegatingLifecycleProvider(Class<? extends Provider<T>> providerClass, Provider<T> delegate) {
        this.providerClass = providerClass;
        this.delegate = delegate;
    }

    @Inject
    public void setInjector(@Nonnull Injector injector) {
        if (this.delegate == null) {
            this.delegate = injector.getInstance(this.providerClass);
        }
    }

    @Override
    public T internalGet() {
        return this.delegate.get();
    }
}

