/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.lifecycle.guice;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import com.nesscomputing.lifecycle.Lifecycle;
import com.nesscomputing.lifecycle.LifecycleListener;
import com.nesscomputing.lifecycle.LifecycleStage;
import com.nesscomputing.lifecycle.guice.OnStage;
import com.nesscomputing.logging.Log;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
class LifecycleAnnotationFinder
implements TypeListener {
    private static final Log LOG = Log.findLog();
    private List<LifecycleInvocation> foundInvocations = Lists.newArrayList();
    private Lifecycle lifecycle;

    LifecycleAnnotationFinder() {
    }

    @Override
    public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
        LOG.trace("Found new injectable type %s", type);
        Class<I> klass = type.getRawType();
        do {
            for (final Method m : klass.getDeclaredMethods()) {
                final OnStage onStage = m.getAnnotation(OnStage.class);
                if (onStage == null) continue;
                LOG.trace("Will invoke %s on %s", m, onStage.value());
                encounter.register(new InjectionListener<I>(){

                    @Override
                    public void afterInjection(I injectee) {
                        LifecycleInvocation invocation = new LifecycleInvocation(new LifecycleStage(onStage.value()), injectee, m);
                        if (LifecycleAnnotationFinder.this.lifecycle != null) {
                            LifecycleAnnotationFinder.this.addListener(invocation);
                        } else {
                            Preconditions.checkState(LifecycleAnnotationFinder.this.foundInvocations != null, "Injection after lifecycle start!");
                            LifecycleAnnotationFinder.this.foundInvocations.add(invocation);
                        }
                    }
                });
            }
        } while ((klass = klass.getSuperclass()) != null);
    }

    void lifecycleAvailable(Lifecycle lifecycle) {
        LOG.debug("Lifecycle now available, draining queue");
        lifecycle.addListener(LifecycleStage.CONFIGURE_STAGE, new LifecycleListener(){

            @Override
            public void onStage(LifecycleStage lifecycleStage) {
                LOG.debug("Lifecycle started, further injections disallowed");
                LifecycleAnnotationFinder.this.lifecycle = null;
            }
        });
        this.lifecycle = lifecycle;
        for (LifecycleInvocation invocation : this.foundInvocations) {
            this.addListener(invocation);
        }
        this.foundInvocations = null;
    }

    void addListener(LifecycleInvocation invocation) {
        Preconditions.checkState(this.lifecycle != null, "no lifecycle");
        invocation.visit(this.lifecycle);
    }

    static class LifecycleInvocation {
        private final LifecycleStage stage;
        private final Method method;
        private final Object object;

        private LifecycleInvocation(LifecycleStage stage, Object object, Method method) {
            this.stage = stage;
            this.object = object;
            this.method = method;
            Preconditions.checkState(method.getParameterTypes().length == 0, "Method '%s' must have no arguments to be a @OnStage method", method);
        }

        void visit(Lifecycle lifecycle) {
            this.method.setAccessible(true);
            lifecycle.addListener(this.stage, new LifecycleListener(){

                @Override
                public void onStage(LifecycleStage lifecycleStage) {
                    try {
                        LifecycleInvocation.this.method.invoke(LifecycleInvocation.this.object, new Object[0]);
                    }
                    catch (IllegalAccessException e) {
                        Throwables.propagate(e);
                    }
                    catch (InvocationTargetException e) {
                        if (e.getCause() == null) {
                            Throwables.propagate(e);
                        }
                        Throwables.propagate(e.getCause());
                    }
                }
            });
        }
    }
}

