/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.lifecycle.junit;

import com.nesscomputing.lifecycle.junit.LifecycleAfter;
import com.nesscomputing.lifecycle.junit.LifecycleBefore;
import com.nesscomputing.lifecycle.junit.LifecycleRule;
import java.util.List;
import org.junit.internal.runners.statements.InvokeMethod;
import org.junit.internal.runners.statements.RunBefores;
import org.junit.rules.RunRules;
import org.junit.rules.TestRule;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class LifecycleRunner
extends BlockJUnit4ClassRunner {
    public LifecycleRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    private Statement withLifecycleRules(FrameworkMethod method, Object target, Statement statement) {
        List<TestRule> testRules = this.getLifecycleRules(target);
        return testRules.isEmpty() ? statement : new RunRules(statement, testRules, this.describeChild(method));
    }

    private Statement withLifecycleBefore(FrameworkMethod method, Object target, Statement statement) {
        List methods = this.getTestClass().getAnnotatedMethods(LifecycleBefore.class);
        return methods.isEmpty() ? statement : new RunBefores(statement, methods, target);
    }

    private Statement withLifecycleAfter(FrameworkMethod method, Object target, Statement statement) {
        List methods = this.getTestClass().getAnnotatedMethods(LifecycleAfter.class);
        return methods.isEmpty() ? statement : new RunBefores(statement, methods, target);
    }

    protected List<TestRule> getLifecycleRules(Object target) {
        return this.getTestClass().getAnnotatedFieldValues(target, LifecycleRule.class, TestRule.class);
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        InvokeMethod s2 = new InvokeMethod(method, test);
        s2 = this.withLifecycleBefore(method, test, (Statement)s2);
        s2 = this.withLifecycleAfter(method, test, (Statement)s2);
        s2 = this.withLifecycleRules(method, test, (Statement)s2);
        return s2;
    }
}

