/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.lifecycle.junit;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Module;
import com.nesscomputing.lifecycle.DefaultLifecycle;
import com.nesscomputing.lifecycle.Lifecycle;
import com.nesscomputing.lifecycle.LifecycleStage;
import com.nesscomputing.lifecycle.ServiceDiscoveryLifecycle;
import com.nesscomputing.lifecycle.guice.AbstractLifecycleModule;
import com.nesscomputing.testing.lessio.AllowAll;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@AllowAll
public final class LifecycleStatement
implements TestRule {
    private final Lifecycle lifecycle;
    private final LifecycleStage startStage;
    private final LifecycleStage stopStage;

    public static LifecycleStatement defaultLifecycle() {
        return new LifecycleStatement(new DefaultLifecycle(), LifecycleStage.START_STAGE, LifecycleStage.STOP_STAGE);
    }

    public static LifecycleStatement serviceDiscoveryLifecycle() {
        return new LifecycleStatement(new ServiceDiscoveryLifecycle(), LifecycleStage.ANNOUNCE_STAGE, LifecycleStage.STOP_STAGE);
    }

    public LifecycleStatement(Lifecycle lifecycle, LifecycleStage startStage, LifecycleStage stopStage) {
        this.lifecycle = lifecycle;
        this.startStage = startStage;
        this.stopStage = stopStage;
    }

    public Module getLifecycleModule() {
        return new AbstractLifecycleModule(){

            @Override
            public void configureLifecycle() {
                this.bind(Lifecycle.class).toInstance(LifecycleStatement.this.lifecycle);
            }
        };
    }

    @VisibleForTesting
    Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    public Statement apply(Statement base, Description description) {
        return new LifecycleStatementWrapper(base);
    }

    public class LifecycleStatementWrapper
    extends Statement {
        private final Statement delegate;

        LifecycleStatementWrapper(Statement delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void evaluate() throws Throwable {
            try {
                LifecycleStatement.this.lifecycle.executeTo(LifecycleStatement.this.startStage);
                this.delegate.evaluate();
            }
            finally {
                LifecycleStatement.this.lifecycle.executeTo(LifecycleStatement.this.stopStage);
            }
        }
    }
}

