/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.log.jmx;

import com.nesscomputing.log.jmx.LogLevel;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.weakref.jmx.Managed;

public class Log4JLevelMBean {
    private final Category logger;
    private volatile long generation = 0L;

    public Log4JLevelMBean(Category logger, long generation) {
        this.logger = logger;
        this.generation = generation;
    }

    void setGeneration(long generation) {
        this.generation = generation;
    }

    long getGeneration() {
        return this.generation;
    }

    @Managed
    public String getName() {
        return this.logger.getName();
    }

    @Managed
    public String getEffectiveLevel() {
        Level level = this.logger.getEffectiveLevel();
        return level != null ? level.toString() : "<unset>";
    }

    @Managed
    public String getLevel() {
        Level level = this.logger.getLevel();
        return level != null ? level.toString() : "<unset>";
    }

    @Managed
    public void setLevel(String levelString) {
        if (levelString == null || levelString.trim().isEmpty()) {
            this.logger.setLevel(null);
        } else {
            LogLevel level = LogLevel.getLogLevel(levelString);
            if (level != null) {
                this.logger.setLevel(level.getLevel());
            }
        }
    }

    @Managed
    public String getParentName() {
        Category parent = this.logger.getParent();
        return parent != null ? parent.getName() : "_ROOT_";
    }
}

