/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.log.jmx;

import com.nesscomputing.log.jmx.Log4JLevelMBean;
import com.nesscomputing.logging.Log;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Category;
import org.apache.log4j.LogManager;
import org.weakref.jmx.MBeanExporter;
import org.weakref.jmx.Managed;

public class Log4JMBean {
    public static final String DEFAULT_OBJECT_NAME = "io.trumpet.log:name=Logger";
    public static final int PRESERVE_PACKAGES = 2;
    private static final Log LOG = Log.findLog();
    private final Map<String, Log4JLevelMBean> levelMBeans = new ConcurrentSkipListMap<String, Log4JLevelMBean>();
    private final Map<Object, String> exportedObjects = new HashMap<Object, String>();
    private final AtomicLong generation = new AtomicLong(0L);
    private final MBeanExporter exporter;
    private final String jmxRoot;
    private LoggerThread loggerThread = null;

    public Log4JMBean(MBeanServer mbeanServer, String jmxRoot) {
        this.exporter = new MBeanExporter(mbeanServer);
        this.jmxRoot = jmxRoot;
    }

    public synchronized void start() {
        this.exportMBean(this.jmxRoot, this);
        Log4JLevelMBean rootLevelMBean = new Log4JLevelMBean(LogManager.getRootLogger(), 0L);
        this.exportMBean(this.buildJMXName("_ROOT_"), rootLevelMBean);
        if (this.loggerThread == null) {
            this.loggerThread = new LoggerThread();
            this.loggerThread.start();
        } else {
            LOG.warn("Ignoring multiple start attempts!");
        }
    }

    public synchronized void stop() {
        if (this.loggerThread != null) {
            this.loggerThread.terminate();
            this.loggerThread = null;
            this.levelMBeans.clear();
            this.unexportMBeans();
        }
    }

    @Managed
    public String[] getLoggerNames() {
        Set<String> mbeans = this.levelMBeans.keySet();
        return mbeans.toArray(new String[mbeans.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportMBean(String name, Object bean) {
        Map<Object, String> map2 = this.exportedObjects;
        synchronized (map2) {
            try {
                this.exporter.export(name, bean);
                this.exportedObjects.put(bean, name);
            }
            catch (RuntimeException re) {
                if (re.getCause() instanceof InstanceAlreadyExistsException) {
                    LOG.warn("Could not export '%s', already exists!", name);
                }
                throw re;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unexportMBeans() {
        Map<Object, String> map2 = this.exportedObjects;
        synchronized (map2) {
            for (String jmxName : this.exportedObjects.values()) {
                try {
                    this.exporter.unexport(jmxName);
                }
                catch (RuntimeException re) {
                    LOG.warn("Could not unexport '%s'!", jmxName);
                }
            }
            this.exportedObjects.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unexportMBean(Object bean) {
        Map<Object, String> map2 = this.exportedObjects;
        synchronized (map2) {
            String key = this.exportedObjects.remove(bean);
            if (key != null) {
                try {
                    this.exporter.unexport(key);
                }
                catch (RuntimeException re) {
                    LOG.warn("Could not unexport '%s'!", key);
                }
            }
        }
    }

    private Log4JLevelMBean locateLevelMBean(Category logger) {
        long currentGeneration = this.generation.get();
        String loggerName = logger.getName();
        Log4JLevelMBean levelMBean = this.levelMBeans.get(loggerName);
        if (levelMBean == null) {
            LOG.trace("No MBean for '%s', creating...", loggerName);
            levelMBean = new Log4JLevelMBean(logger, currentGeneration);
            this.exportMBean(this.buildJMXName(loggerName), levelMBean);
            this.levelMBeans.put(loggerName, levelMBean);
        } else {
            levelMBean.setGeneration(currentGeneration);
        }
        return levelMBean;
    }

    private String buildJMXName(String loggerName) {
        Object[] pieces = StringUtils.split(loggerName, ".");
        StringBuilder jmxName = new StringBuilder(this.jmxRoot);
        jmxName.append(",logger=");
        if (pieces.length < 2) {
            jmxName.append(loggerName);
        } else {
            jmxName.append(StringUtils.join(pieces, ".", 0, 2));
            for (int i = 2; i < pieces.length; ++i) {
                jmxName.append(",logger");
                jmxName.append(i);
                jmxName.append("=");
                jmxName.append((String)pieces[i]);
            }
        }
        return jmxName.toString();
    }

    private class LoggerThread
    extends Thread {
        private volatile boolean running;

        private LoggerThread() {
            super("jmx-log4j");
            this.running = true;
            this.setDaemon(true);
            this.updateLevelMBeans(Log4JMBean.this.generation.get());
        }

        private void terminate() {
            this.running = false;
            this.interrupt();
            try {
                this.join();
            }
            catch (InterruptedException ioe) {
                Thread.currentThread().interrupt();
            }
        }

        @Override
        public void run() {
            while (this.running) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ioe) {
                    Thread.currentThread().interrupt();
                    this.running = false;
                    break;
                }
                long currentGeneration = Log4JMBean.this.generation.incrementAndGet();
                this.updateLevelMBeans(currentGeneration);
            }
        }

        private void updateLevelMBeans(long currentGeneration) {
            Enumeration e = LogManager.getCurrentLoggers();
            while (e.hasMoreElements()) {
                Category logger = (Category)e.nextElement();
                Log4JMBean.this.locateLevelMBean(logger);
            }
            Iterator it = Log4JMBean.this.levelMBeans.values().iterator();
            while (it.hasNext()) {
                Log4JLevelMBean levelMBean = (Log4JLevelMBean)it.next();
                if (levelMBean.getGeneration() >= currentGeneration) continue;
                LOG.trace("MBean for '%s' no longer active, removing", levelMBean.getName());
                it.remove();
                Log4JMBean.this.unexportMBean(levelMBean);
            }
        }
    }
}

