/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.log.jmx;

import org.apache.log4j.Level;

public enum LogLevel {
    ALL(Level.ALL, false),
    TRACE(Level.TRACE, true),
    DEBUG(Level.DEBUG, true),
    INFO(Level.INFO, true),
    WARN(Level.WARN, true),
    ERROR(Level.ERROR, true),
    FATAL(Level.FATAL, false),
    OFF(Level.OFF, false);

    private final Level level;
    private final boolean reasonable;

    private LogLevel(Level level, boolean reasonable) {
        this.level = level;
        this.reasonable = reasonable;
    }

    public Level getLevel() {
        return this.level;
    }

    public boolean isReasonable() {
        return this.reasonable;
    }

    public static final LogLevel getLogLevel(Level level) {
        for (LogLevel logLevel : LogLevel.values()) {
            if (!logLevel.getLevel().equals(level)) continue;
            return logLevel;
        }
        throw new IllegalArgumentException("Unknown level " + level + " encountered!");
    }

    public static final LogLevel getLogLevel(String levelName) {
        for (LogLevel logLevel : LogLevel.values()) {
            if (!logLevel.name().equals(levelName) || !logLevel.isReasonable()) continue;
            return logLevel;
        }
        return null;
    }
}

