/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.log.jmx.guice;

import com.google.common.base.Preconditions;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Names;
import com.nesscomputing.lifecycle.Lifecycle;
import com.nesscomputing.lifecycle.LifecycleStage;
import com.nesscomputing.lifecycle.guice.AbstractLifecycleProvider;
import com.nesscomputing.lifecycle.guice.LifecycleAction;
import com.nesscomputing.log.jmx.Log4JMBean;
import javax.management.MBeanServer;

public class JmxLoggingModule
extends AbstractModule {
    private final String context;

    public JmxLoggingModule(String context) {
        this.context = context;
    }

    @Override
    public void configure() {
        this.bind(Log4JMBean.class).annotatedWith(Names.named(this.context)).toProvider(new Log4JMBeanProvider(this.context)).asEagerSingleton();
    }

    public final class Log4JMBeanProvider
    extends AbstractLifecycleProvider<Log4JMBean>
    implements Provider<Log4JMBean> {
        private final String context;
        private Lifecycle lifecycle = null;
        private MBeanServer mbeanServer = null;

        private Log4JMBeanProvider(String context) {
            this.context = context;
            this.addAction(LifecycleStage.START_STAGE, new LifecycleAction<Log4JMBean>(){

                @Override
                public void performAction(Log4JMBean log4jMBean) {
                    log4jMBean.start();
                }
            });
            this.addAction(LifecycleStage.STOP_STAGE, new LifecycleAction<Log4JMBean>(){

                @Override
                public void performAction(Log4JMBean log4jMBean) {
                    log4jMBean.stop();
                }
            });
        }

        @Inject
        public void setDependencies(Lifecycle lifecycle, MBeanServer mbeanServer) {
            this.lifecycle = lifecycle;
            this.mbeanServer = mbeanServer;
        }

        @Override
        protected Log4JMBean internalGet() {
            Preconditions.checkNotNull(this.lifecycle, "lifecycle is null, missed call to setDependencies()?");
            Preconditions.checkNotNull(this.mbeanServer, "mbeanServer is null, missed call to setDependencies()?");
            return new Log4JMBean(this.mbeanServer, "io.trumpet.log:name=Logger,context=" + this.context);
        }
    }
}

