/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.log4j.testing;

import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class RecordingAppender
extends AppenderSkeleton {
    private StringBuilder sb = new StringBuilder();
    private Level level = null;
    private ThrowableInformation ti = null;

    public RecordingAppender() {
    }

    public RecordingAppender(String layout) {
        this.setLayout(new PatternLayout(layout));
    }

    public void clear() {
        this.sb = new StringBuilder();
        this.level = null;
        this.ti = null;
    }

    public String getContents() {
        return this.sb.toString();
    }

    public Level getLevel() {
        return this.level;
    }

    public String getThrowable() {
        return this.ti != null ? this.ti.getThrowableStrRep()[0] : null;
    }

    public String[] getStackTrace() {
        return this.ti != null ? this.ti.getThrowableStrRep() : null;
    }

    @Override
    protected void append(LoggingEvent event) {
        this.level = event.getLevel();
        this.ti = event.getThrowableInformation();
        Layout layout = this.getLayout();
        if (layout == null) {
            this.sb.append(event.getRenderedMessage());
            this.sb.append("\n");
        } else {
            this.sb.append(layout.format(event));
        }
    }

    @Override
    public void close() {
        this.clear();
    }

    @Override
    public boolean requiresLayout() {
        return false;
    }
}

