/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.logging;

import com.nesscomputing.logging.Log;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.bridge.SLF4JBridgeHandler;

public final class AssimilateForeignLogging {
    private static final Log LOG = Log.findLog();
    private static final String AUTO_ASSIMILATE_PROPERTY = "ness.log.assimilate";
    @GuardedBy(value="AssimilateForeignLogging.class")
    private static boolean assimilated = false;

    private AssimilateForeignLogging() {
    }

    public static synchronized void assimilate() {
        if (assimilated) {
            return;
        }
        assimilated = true;
        Logger rootLogger = LogManager.getLogManager().getLogger("");
        Handler[] handlers = rootLogger.getHandlers();
        if (handlers != null) {
            for (Handler handler : handlers) {
                rootLogger.removeHandler(handler);
            }
        }
        SLF4JBridgeHandler.install();
        LOG.info("java.util.logging was assimilated.");
    }

    public static synchronized void unassimilate() {
        SLF4JBridgeHandler.uninstall();
    }

    public static void automaticAssimilationHook() {
        if (System.getProperty(AUTO_ASSIMILATE_PROPERTY) != null) {
            AssimilateForeignLogging.assimilate();
        }
    }
}

