/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.server;

import com.google.common.base.Throwables;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.nesscomputing.lifecycle.guice.OnStage;
import com.nesscomputing.logging.Log;
import com.nesscomputing.server.JvmPauseAlarmConfig;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@Singleton
class JvmPauseAlarm
implements Runnable {
    private static final Log LOG = Log.findLog();
    private static final long S_THRESHOLD = 1000L;
    private final JvmPauseAlarmConfig config;

    @Inject
    JvmPauseAlarm(JvmPauseAlarmConfig config) {
        this.config = config;
    }

    @OnStage(value="start")
    public void start() {
        if (!this.config.isPauseAlarmEnabled()) {
            return;
        }
        ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("jvm-pause-alarm").build());
        executor.submit(this);
        executor.shutdown();
    }

    @Override
    public void run() {
        try {
            this.safeRun();
        }
        catch (Exception e) {
            LOG.error(e, "Exiting due to exception");
            throw Throwables.propagate(e);
        }
    }

    private void safeRun() {
        long sleepTime = this.config.getCheckTime().getMillis();
        long alarmTime = this.config.getPauseAlarmTime().getMillis();
        LOG.info("Watching JVM for GC pausing.  Checking every %s for pauses of at least %s.", this.config.getCheckTime(), this.config.getPauseAlarmTime());
        long lastUpdate = System.currentTimeMillis();
        while (true) {
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOG.info("Exiting due to interrupt");
                return;
            }
            long now = System.currentTimeMillis();
            long pauseMs = now - lastUpdate;
            if (pauseMs > alarmTime) {
                LOG.warn("Detected pause of %s!", pauseMs > 1000L ? String.format("%.1fs", (double)pauseMs / 1000.0) : pauseMs + "ms");
            }
            lastUpdate = now;
        }
    }
}

