/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.server;

import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.nesscomputing.config.Config;
import com.nesscomputing.config.ConfigModule;
import com.nesscomputing.jmx.JmxModule;
import com.nesscomputing.jmx.starter.guice.JmxStarterModule;
import com.nesscomputing.lifecycle.Lifecycle;
import com.nesscomputing.lifecycle.LifecycleStage;
import com.nesscomputing.lifecycle.guice.LifecycleModule;
import com.nesscomputing.log.jmx.guice.JmxLoggingModule;
import com.nesscomputing.log4j.ConfigureStandaloneLogging;
import com.nesscomputing.logging.AssimilateForeignLogging;
import com.nesscomputing.logging.Log;
import com.nesscomputing.server.JvmPauseAlarmModule;
import com.nesscomputing.serverinfo.ServerInfo;
import java.util.UUID;
import org.apache.commons.lang3.time.StopWatch;

public abstract class StandaloneServer {
    private static final Log LOG = Log.findLog();
    private final String serverToken;
    private final Thread shutdownThread = new Thread("Server Shutdown Thread"){

        @Override
        public void run() {
            LOG.info("Shutting Service down");
            StandaloneServer.this.doStopServer(true);
        }
    };
    @Inject
    private Lifecycle lifecycle;
    private boolean started = false;
    private boolean stopped = false;

    public StandaloneServer() {
        this.serverToken = UUID.randomUUID().toString();
        ConfigureStandaloneLogging.configure(this.getServerType());
        AssimilateForeignLogging.assimilate();
    }

    protected abstract Module getMainModule(Config var1);

    protected abstract String getServerType();

    public void startServer() {
        Preconditions.checkState(!this.started, "Server was already started, double-start denied!");
        ServerInfo.add("server-type", this.getServerType());
        ServerInfo.add("server-token", this.getServerToken());
        Object binaryVersion = ServerInfo.get("server-binary");
        LOG.info("Service startup begins (type: %s, token: %s)", ServerInfo.get("server-type"), ServerInfo.get("server-token"));
        if (binaryVersion != null) {
            LOG.info("Binary: %s, version: %s, running in %s mode.", binaryVersion, ServerInfo.get("server-version"), ServerInfo.get("server-mode"));
        }
        StopWatch timer = new StopWatch();
        timer.start();
        Injector injector = this.getInjector();
        injector.injectMembers(this);
        timer.stop();
        long injectorTime = timer.getTime();
        timer.reset();
        Preconditions.checkNotNull(this.lifecycle, "No Lifecycle Object was injected!");
        Runtime.getRuntime().addShutdownHook(this.shutdownThread);
        LOG.info("Starting Service");
        timer.start();
        this.lifecycle.executeTo(this.getStartStage());
        timer.stop();
        this.started = true;
        LOG.info("Service startup completed; %d ms in module initialization and %d ms to start lifecycle.", injectorTime, timer.getTime());
    }

    public void stopServer() {
        this.doStopServer(false);
    }

    private final void doStopServer(boolean fromHook) {
        Preconditions.checkState(!this.stopped, "Server was already stopped, double-stop denied!");
        Preconditions.checkNotNull(this.lifecycle, "No Lifecycle Object was injected!");
        LOG.info("Stopping Service");
        this.lifecycle.executeTo(this.getStopStage());
        if (!fromHook) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
        }
        this.stopped = true;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public Module getPlumbingModules(final Config config) {
        return new Module(){

            @Override
            public void configure(Binder binder) {
                binder.install(new ConfigModule(config));
                binder.install(StandaloneServer.this.getLifecycleModule());
                binder.install(new JmxModule());
                binder.install(new JmxStarterModule(config));
                binder.install(new JmxLoggingModule(StandaloneServer.this.getServerType()));
                binder.install(new JvmPauseAlarmModule());
            }
        };
    }

    public Config getConfig() {
        return Config.getConfig();
    }

    public final Injector getInjector() {
        Config config = this.getConfig();
        Injector injector = Guice.createInjector(Stage.PRODUCTION, this.getPlumbingModules(config), this.getMainModule(config), new Module(){

            @Override
            public void configure(Binder binder) {
                binder.requireExplicitBindings();
                binder.disableCircularProxies();
            }
        });
        return injector;
    }

    protected LifecycleStage getStartStage() {
        return LifecycleStage.START_STAGE;
    }

    protected LifecycleStage getStopStage() {
        return LifecycleStage.STOP_STAGE;
    }

    protected Module getLifecycleModule() {
        return new LifecycleModule();
    }

    protected String getServerToken() {
        return this.serverToken;
    }
}

