/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.serverinfo;

import com.google.inject.Singleton;
import com.nesscomputing.httpclient.HttpClientObserver;
import com.nesscomputing.httpclient.HttpClientRequest;
import com.nesscomputing.serverinfo.ServerInfo;

@Singleton
public class HttpClientServerInfoObserver
extends HttpClientObserver {
    public static final String X_NESS_SERVER_BINARY = "X-Ness-Server-Binary";
    public static final String X_NESS_SERVER_VERSION = "X-Ness-Server-Version";
    public static final String X_NESS_SERVER_MODE = "X-Ness-Server-Mode";
    public static final String X_NESS_SERVER_TYPE = "X-Ness-Server-Type";
    public static final String X_NESS_SERVER_TOKEN = "X-Ness-Server-Token";

    @Override
    public <RequestType> HttpClientRequest<RequestType> onRequestSubmitted(HttpClientRequest<RequestType> request) {
        HttpClientRequest.Builder<RequestType> builder = HttpClientRequest.Builder.fromRequest(request);
        this.addHeader(builder, "server-binary", X_NESS_SERVER_BINARY);
        this.addHeader(builder, "server-version", X_NESS_SERVER_VERSION);
        this.addHeader(builder, "server-mode", X_NESS_SERVER_MODE);
        this.addHeader(builder, "server-type", X_NESS_SERVER_TYPE);
        this.addHeader(builder, "server-token", X_NESS_SERVER_TOKEN);
        return builder.request();
    }

    private <RequestType> void addHeader(HttpClientRequest.Builder<RequestType> builder, String serverInfoKey, String headerName) {
        Object value2 = ServerInfo.get(serverInfoKey);
        if (value2 != null) {
            builder.replaceHeader(headerName, value2.toString());
        }
    }
}

