/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.serverinfo;

import com.google.common.base.Preconditions;
import com.nesscomputing.logging.Log;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.MDC;

public final class ServerInfo {
    private static final Log LOG = Log.findLog();
    private static final Object NULL_VALUE = new Object();
    private static final ServerInfo SERVER_INFO;
    public static final String SERVER_BINARY = "server-binary";
    public static final String SERVER_VERSION = "server-version";
    public static final String SERVER_MODE = "server-mode";
    public static final String SERVER_TYPE = "server-type";
    public static final String SERVER_TOKEN = "server-token";
    private static final String NESS_BINARY_KEY = "X-Ness-Binary";
    private static final String NESS_VERSION_KEY = "X-Ness-Version";
    private static final String NESS_MODE_KEY = "X-Ness-Mode";
    private final Map<String, Object> info = new ConcurrentHashMap<String, Object>();

    public static void add(@Nonnull String key, @Nullable Object value2) {
        SERVER_INFO.register(key, value2);
    }

    public static void remove(@Nonnull String key) {
        SERVER_INFO.unregister(key);
    }

    public static Object get(@Nonnull String key) {
        return SERVER_INFO.retrieve(key);
    }

    public static void clear() {
        SERVER_INFO.clean();
    }

    public static void registerServerInfo(@Nonnull String className) {
        SERVER_INFO.registerServerInformation(className);
    }

    private ServerInfo(String baseClass) {
        if (baseClass != null) {
            this.registerServerInformation(baseClass);
        }
    }

    private void register(final String key, Object value2) {
        Preconditions.checkNotNull(key != null, "The key must not be null!");
        if (value2 != null) {
            this.info.put(key, value2);
            MDC.put(key, new Object(){

                public String toString() {
                    return String.valueOf(ServerInfo.get(key));
                }
            });
        } else {
            this.info.put(key, NULL_VALUE);
            MDC.remove(key);
        }
    }

    private void unregister(String key) {
        Preconditions.checkNotNull(key != null, "The key must not be null!");
        MDC.remove(key);
        this.info.remove(key);
    }

    private Object retrieve(String key) {
        Preconditions.checkNotNull(key != null, "The key must not be null!");
        Object o = this.info.get(key);
        return o == NULL_VALUE ? null : o;
    }

    private void clean() {
        Iterator<String> it = this.info.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next();
            MDC.remove(key);
            it.remove();
        }
    }

    private void registerServerInformation(String className) {
        try {
            Enumeration<URL> manifests = ServerInfo.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (manifests.hasMoreElements()) {
                try {
                    URL url = manifests.nextElement();
                    Manifest manifest = new Manifest(url.openStream());
                    Attributes classAttributes = manifest.getAttributes(className);
                    if (classAttributes == null) continue;
                    this.register(SERVER_BINARY, classAttributes.getValue(NESS_BINARY_KEY));
                    this.register(SERVER_VERSION, classAttributes.getValue(NESS_VERSION_KEY));
                    this.register(SERVER_MODE, classAttributes.getValue(NESS_MODE_KEY));
                    LOG.debug("Found manifest, set values to binary=%s, version=%s, type=%s", this.retrieve(SERVER_BINARY), this.retrieve(SERVER_VERSION), this.retrieve(SERVER_MODE));
                    return;
                }
                catch (IOException ioe) {
                    LOG.warnDebug(ioe, "While loading manifest");
                }
                catch (NoClassDefFoundError ncdfe) {
                    LOG.warnDebug(ncdfe, "While loading manifest!");
                }
            }
            LOG.info("Could not locate manifest information for server, looked for %s.", className);
        }
        catch (IOException ioe) {
            LOG.warnDebug(ioe, "Manifest information is unavailable!");
        }
    }

    public String toString() {
        return this.info.toString();
    }

    static {
        StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
        String baseClass = null;
        for (int i = stacktrace.length - 1; i >= 0; --i) {
            if (stacktrace[i].getClassName().contains("surefire") || !"main".equals(stacktrace[i].getMethodName())) continue;
            baseClass = stacktrace[i].getClassName();
            break;
        }
        SERVER_INFO = new ServerInfo(baseClass);
    }
}

