/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.syslog4j.impl.message.modifier.escape;

import com.nesscomputing.syslog4j.SyslogFacility;
import com.nesscomputing.syslog4j.SyslogIF;
import com.nesscomputing.syslog4j.SyslogLevel;
import com.nesscomputing.syslog4j.SyslogMessageModifierIF;
import org.apache.commons.lang3.StringUtils;

public class HTMLEntityEscapeSyslogMessageModifier
implements SyslogMessageModifierIF {
    public static final SyslogMessageModifierIF createDefault() {
        return new HTMLEntityEscapeSyslogMessageModifier();
    }

    @Override
    public String modify(SyslogIF syslog, SyslogFacility facility, SyslogLevel level, String message) {
        if (StringUtils.isBlank(message)) {
            return message;
        }
        String escapedMessage = HTMLEntityEscapeSyslogMessageModifier.escapeHtml(message);
        return escapedMessage;
    }

    @Override
    public boolean verify(String message) {
        return true;
    }

    public static String escapeHtml(String message) {
        StringBuffer b = new StringBuffer(message.length());
        for (int i = 0; i < message.length(); ++i) {
            char ch = message.charAt(i);
            if (ch == '<') {
                b.append("&lt;");
                continue;
            }
            if (ch == '>') {
                b.append("&gt;");
                continue;
            }
            if (ch == '\"') {
                b.append("&quot;");
                continue;
            }
            if (ch == '\'') {
                b.append("&#39;");
                continue;
            }
            if (ch == '&') {
                b.append("&amp;");
                continue;
            }
            if (ch >= ' ' && ch <= '~') {
                b.append(ch);
                continue;
            }
            if (Character.isWhitespace(ch)) {
                b.append("&#").append((int)ch).append(";");
                continue;
            }
            if (Character.isISOControl(ch) || !Character.isDefined(ch)) continue;
            b.append("&#").append((int)ch).append(";");
        }
        return b.toString();
    }
}

