/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.syslog4j.impl.message.modifier.text;

import com.nesscomputing.syslog4j.SyslogFacility;
import com.nesscomputing.syslog4j.SyslogIF;
import com.nesscomputing.syslog4j.SyslogLevel;
import com.nesscomputing.syslog4j.SyslogMessageModifierIF;
import com.nesscomputing.syslog4j.SyslogRuntimeException;

public class StringCaseSyslogMessageModifier
implements SyslogMessageModifierIF {
    public static final byte LOWER_CASE = 0;
    public static final byte UPPER_CASE = 1;
    public static final StringCaseSyslogMessageModifier LOWER = new StringCaseSyslogMessageModifier(0);
    public static final StringCaseSyslogMessageModifier UPPER = new StringCaseSyslogMessageModifier(1);
    protected byte stringCase = 0;

    public StringCaseSyslogMessageModifier(byte stringCase) {
        this.stringCase = stringCase;
        if (stringCase < 0 || stringCase > 1) {
            throw new SyslogRuntimeException("stringCase must be LOWER_CASE (0) or UPPER_CASE (1)", new Object[0]);
        }
    }

    @Override
    public String modify(SyslogIF syslog, SyslogFacility facility, SyslogLevel level, String message) {
        String _message = message;
        if (message != null) {
            if (this.stringCase == 0) {
                _message = _message.toLowerCase();
            } else if (this.stringCase == 1) {
                _message = _message.toUpperCase();
            }
        }
        return _message;
    }

    @Override
    public boolean verify(String message) {
        return true;
    }
}

