/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.syslog4j.impl.message.structured;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.nesscomputing.syslog4j.impl.message.AbstractSyslogMessage;
import com.nesscomputing.syslog4j.impl.message.structured.StructuredSyslogMessageIF;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class StructuredSyslogMessage
extends AbstractSyslogMessage
implements StructuredSyslogMessageIF {
    private String messageId;
    private Map<String, Map<String, String>> structuredData;
    private String message;
    private String procId;

    private StructuredSyslogMessage() {
        this.messageId = null;
        this.message = null;
        this.procId = null;
        this.structuredData = null;
    }

    public StructuredSyslogMessage(String messageId, String procId, Map<String, Map<String, String>> structuredData, String message) {
        this.messageId = messageId;
        this.procId = procId;
        this.structuredData = structuredData;
        this.message = message;
    }

    public static StructuredSyslogMessage fromString(String syslogMessageStr) {
        StructuredSyslogMessage syslogMessage = new StructuredSyslogMessage();
        syslogMessage.deserialize(syslogMessageStr);
        return syslogMessage;
    }

    private void deserialize(String stringMessage) {
        if (stringMessage.indexOf(91) <= 0) {
            throw new IllegalArgumentException("Invalid Syslog string format: " + stringMessage);
        }
        String syslogHeader = stringMessage.substring(0, stringMessage.indexOf(91));
        String structuredDataString = stringMessage.substring(stringMessage.indexOf(91), stringMessage.lastIndexOf(93) + 1);
        this.message = stringMessage.lastIndexOf(93) + 2 <= stringMessage.length() ? stringMessage.substring(stringMessage.lastIndexOf(93) + 2) : "";
        String[] tokens = syslogHeader.split(" ");
        if (tokens.length != 1) {
            throw new IllegalArgumentException("Invalid Syslog string format: " + stringMessage);
        }
        this.messageId = "-".equals(tokens[0]) ? null : tokens[0];
        this.structuredData = this.parseStructuredData(structuredDataString);
    }

    public String getMessageId() {
        return this.messageId;
    }

    public Map<String, Map<String, String>> getStructuredData() {
        return this.structuredData;
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public String getProcId() {
        return this.procId;
    }

    @Override
    public String createMessage() {
        return this.serialize();
    }

    private String serialize() {
        if (!StructuredSyslogMessage.checkIsPrintable(this.getMessageId())) {
            throw new IllegalArgumentException("Invalid message id: " + this.getMessageId());
        }
        StringBuffer sb = new StringBuffer();
        sb.append(StructuredSyslogMessage.nilProtect(this.getMessageId()));
        sb.append(' ');
        if (this.getStructuredData() == null || this.getStructuredData().size() == 0) {
            sb.append("[0@0]");
        } else {
            Set<Map.Entry<String, Map<String, String>>> sdEntrySet = this.getStructuredData().entrySet();
            for (Map.Entry<String, Map<String, String>> sdElement : sdEntrySet) {
                String sdId = sdElement.getKey();
                if (StringUtils.isBlank(sdId) || !StructuredSyslogMessage.checkIsPrintable(sdId)) {
                    throw new IllegalArgumentException("Illegal structured data id: " + sdId);
                }
                sb.append('[').append(sdId);
                Map<String, String> sdParams = sdElement.getValue();
                if (sdParams != null) {
                    Set<Map.Entry<String, String>> entrySet = sdParams.entrySet();
                    for (Map.Entry<String, String> entry : entrySet) {
                        String paramName = entry.getKey();
                        String paramValue = entry.getValue();
                        if (StringUtils.isBlank(paramName) || !StructuredSyslogMessage.checkIsPrintable(paramName)) {
                            throw new IllegalArgumentException("Illegal structured data parameter name: " + paramName);
                        }
                        if (paramValue == null) {
                            throw new IllegalArgumentException("Null structured data parameter value for parameter name: " + paramName);
                        }
                        sb.append(' ');
                        sb.append(paramName);
                        sb.append('=').append('\"');
                        StructuredSyslogMessage.sdEscape(sb, paramValue);
                        sb.append('\"');
                    }
                }
                sb.append(']');
            }
        }
        if (!StringUtils.isEmpty(this.getMessage())) {
            sb.append(' ');
            sb.append(StructuredSyslogMessage.nilProtect(this.getMessage()));
        }
        return sb.toString();
    }

    public static void sdEscape(StringBuffer sb, String value2) {
        for (int i = 0; i < value2.length(); ++i) {
            char c = value2.charAt(i);
            if (c == '\"' || c == '\\' || c == ']') {
                sb.append('\\');
            }
            sb.append(c);
        }
    }

    public static boolean checkIsPrintable(String value2) {
        if (value2 == null) {
            return true;
        }
        for (int i = 0; i < value2.length(); ++i) {
            char c = value2.charAt(i);
            if (c >= '!' && c <= '~') continue;
            return false;
        }
        return true;
    }

    public static String nilProtect(String value2) {
        if (StringUtils.isBlank(value2)) {
            return "-";
        }
        return value2;
    }

    private Map<String, Map<String, String>> parseStructuredData(String data2) {
        if (data2 == null || "[0@0]".equals(data2)) {
            return Collections.emptyMap();
        }
        HashMap<String, Map<String, String>> structuredDataMap = Maps.newHashMap();
        int end = -1;
        for (int start = 0; start < data2.length(); ++start) {
            Preconditions.checkArgument(data2.charAt(start) == '[', "Invalid structured data in syslog message '%s'", data2);
            end = StructuredSyslogMessage.matchChar(data2, start, ']');
            Preconditions.checkArgument(end != -1 && data2.charAt(end) == ']', "Invalid structured data in syslog message '%s'", data2);
            String key = null;
            HashMap<String, String> keyMap = Maps.newHashMap();
            while (start < end) {
                if (key == null) {
                    int keyEnd = StructuredSyslogMessage.matchChar(data2, ++start, ']', ' ');
                    key = data2.substring(start, keyEnd);
                    start = keyEnd;
                    continue;
                }
                Preconditions.checkArgument(start < data2.length() && data2.charAt(start) == ' ', "Invalid structured data in syslog message '%s'", data2);
                Preconditions.checkArgument(key != null, "Invalid structured data in syslog message '%s'", data2);
                int equalsIndex = data2.indexOf(61, ++start);
                Preconditions.checkArgument(equalsIndex != -1, "Invalid structured data in syslog message '%s'", data2);
                Preconditions.checkArgument(data2.charAt(equalsIndex + 1) == '\"', "Invalid structured data in syslog message '%s'", data2);
                int valueEnd = StructuredSyslogMessage.matchChar(data2, equalsIndex + 2, '\"');
                Preconditions.checkArgument(valueEnd != -1 && data2.charAt(valueEnd) == '\"', "Invalid structured data in syslog message '%s'", data2);
                keyMap.put(data2.substring(start, equalsIndex), this.unescape(data2.substring(equalsIndex + 2, valueEnd)));
                start = valueEnd + 1;
            }
            structuredDataMap.put(key, keyMap);
        }
        return structuredDataMap;
    }

    @VisibleForTesting
    static int matchChar(String data2, int start, char ... matchChars) {
        int ptr = start;
        while (ptr < data2.length()) {
            if (data2.charAt(ptr) == '\\') {
                ++ptr;
                ++ptr;
                continue;
            }
            if (ptr >= data2.length()) {
                return -1;
            }
            for (int i = 0; i < matchChars.length; ++i) {
                if (data2.charAt(ptr) != matchChars[i]) continue;
                return ptr;
            }
            ++ptr;
        }
        return -1;
    }

    private String unescape(String str) {
        if (str.indexOf(92) == -1) {
            return str;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '\\') continue;
            sb.append(str.charAt(i));
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.message == null ? 0 : this.message.hashCode());
        result2 = 31 * result2 + (this.messageId == null ? 0 : this.messageId.hashCode());
        result2 = 31 * result2 + (this.structuredData == null ? 0 : ((Object)this.structuredData).hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StructuredSyslogMessage other = (StructuredSyslogMessage)obj;
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        if (this.messageId == null ? other.messageId != null : !this.messageId.equals(other.messageId)) {
            return false;
        }
        return !(this.structuredData == null ? other.structuredData != null : !((Object)this.structuredData).equals(other.structuredData));
    }

    public String toString() {
        return this.serialize();
    }
}

