/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.syslog4j.impl.multiple;

import com.nesscomputing.syslog4j.Syslog;
import com.nesscomputing.syslog4j.SyslogConfigIF;
import com.nesscomputing.syslog4j.SyslogIF;
import com.nesscomputing.syslog4j.SyslogLevel;
import com.nesscomputing.syslog4j.SyslogMessageIF;
import com.nesscomputing.syslog4j.SyslogMessageProcessorIF;
import com.nesscomputing.syslog4j.SyslogRuntimeException;
import com.nesscomputing.syslog4j.impl.multiple.MultipleSyslogConfig;

public class MultipleSyslog
implements SyslogIF {
    protected String syslogProtocol = null;
    protected MultipleSyslogConfig multipleSyslogConfig = null;

    @Override
    public void initialize(String protocol, SyslogConfigIF config) throws SyslogRuntimeException {
        this.syslogProtocol = protocol;
        try {
            this.multipleSyslogConfig = (MultipleSyslogConfig)config;
        }
        catch (ClassCastException cce) {
            throw new SyslogRuntimeException("config must be of type MultipleSyslogConfig", new Object[0]);
        }
    }

    @Override
    public SyslogConfigIF getConfig() {
        return this.multipleSyslogConfig;
    }

    @Override
    public void debug(String message) {
        this.log(SyslogLevel.DEBUG, message);
    }

    @Override
    public void debug(SyslogMessageIF message) {
        this.log(SyslogLevel.DEBUG, message);
    }

    @Override
    public void critical(String message) {
        this.log(SyslogLevel.CRITICAL, message);
    }

    @Override
    public void critical(SyslogMessageIF message) {
        this.log(SyslogLevel.CRITICAL, message);
    }

    @Override
    public void error(String message) {
        this.log(SyslogLevel.ERROR, message);
    }

    @Override
    public void error(SyslogMessageIF message) {
        this.log(SyslogLevel.ERROR, message);
    }

    @Override
    public void alert(String message) {
        this.log(SyslogLevel.ALERT, message);
    }

    @Override
    public void alert(SyslogMessageIF message) {
        this.log(SyslogLevel.ALERT, message);
    }

    @Override
    public void notice(String message) {
        this.log(SyslogLevel.NOTICE, message);
    }

    @Override
    public void notice(SyslogMessageIF message) {
        this.log(SyslogLevel.NOTICE, message);
    }

    @Override
    public void emergency(String message) {
        this.log(SyslogLevel.EMERGENCY, message);
    }

    @Override
    public void emergency(SyslogMessageIF message) {
        this.log(SyslogLevel.EMERGENCY, message);
    }

    @Override
    public void info(String message) {
        this.log(SyslogLevel.INFO, message);
    }

    @Override
    public void info(SyslogMessageIF message) {
        this.log(SyslogLevel.INFO, message);
    }

    @Override
    public void warn(String message) {
        this.log(SyslogLevel.WARN, message);
    }

    @Override
    public void warn(SyslogMessageIF message) {
        this.log(SyslogLevel.WARN, message);
    }

    @Override
    public void log(SyslogLevel level, String message) {
        for (int i = 0; i < this.multipleSyslogConfig.getProtocols().size(); ++i) {
            String protocol = this.multipleSyslogConfig.getProtocols().get(i);
            SyslogIF syslog = Syslog.getInstance(protocol);
            syslog.log(level, message);
        }
    }

    @Override
    public void log(SyslogLevel level, SyslogMessageIF message) {
        for (int i = 0; i < this.multipleSyslogConfig.getProtocols().size(); ++i) {
            String protocol = this.multipleSyslogConfig.getProtocols().get(i);
            SyslogIF syslog = Syslog.getInstance(protocol);
            syslog.log(level, message);
        }
    }

    @Override
    public void flush() throws SyslogRuntimeException {
        for (int i = 0; i < this.multipleSyslogConfig.getProtocols().size(); ++i) {
            String protocol = this.multipleSyslogConfig.getProtocols().get(i);
            SyslogIF syslog = Syslog.getInstance(protocol);
            syslog.flush();
        }
    }

    @Override
    public void shutdown() throws SyslogRuntimeException {
        for (int i = 0; i < this.multipleSyslogConfig.getProtocols().size(); ++i) {
            String protocol = this.multipleSyslogConfig.getProtocols().get(i);
            SyslogIF syslog = Syslog.getInstance(protocol);
            syslog.shutdown();
        }
    }

    @Override
    public void backLog(SyslogLevel level, String message, Throwable reasonThrowable) {
    }

    @Override
    public void backLog(SyslogLevel level, String message, String reason) {
    }

    @Override
    public void setMessageProcessor(SyslogMessageProcessorIF messageProcessor) {
        throw new SyslogRuntimeException("MultipleSyslog is an aggregator; please set the individual protocols", new Object[0]);
    }

    @Override
    public SyslogMessageProcessorIF getMessageProcessor() {
        throw new SyslogRuntimeException("MultipleSyslog is an aggregator; please set the individual protocols", new Object[0]);
    }

    @Override
    public void setStructuredMessageProcessor(SyslogMessageProcessorIF messageProcessor) {
        throw new SyslogRuntimeException("MultipleSyslog is an aggregator; please set the individual protocols", new Object[0]);
    }

    @Override
    public SyslogMessageProcessorIF getStructuredMessageProcessor() {
        throw new SyslogRuntimeException("MultipleSyslog is an aggregator; please set the individual protocols", new Object[0]);
    }

    @Override
    public String getProtocol() {
        return this.syslogProtocol;
    }
}

