/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.syslog4j.impl.multiple;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.nesscomputing.syslog4j.SyslogBackLogHandlerIF;
import com.nesscomputing.syslog4j.SyslogConfigIF;
import com.nesscomputing.syslog4j.SyslogFacility;
import com.nesscomputing.syslog4j.SyslogIF;
import com.nesscomputing.syslog4j.SyslogMessageModifierIF;
import com.nesscomputing.syslog4j.SyslogRuntimeException;
import com.nesscomputing.syslog4j.impl.multiple.MultipleSyslog;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class MultipleSyslogConfig
implements SyslogConfigIF {
    protected List<String> syslogProtocols = null;

    public MultipleSyslogConfig() {
        this.syslogProtocols = Lists.newArrayList();
    }

    public MultipleSyslogConfig(List<String> protocols) {
        this.syslogProtocols = protocols != null ? protocols : Lists.newArrayList();
    }

    public MultipleSyslogConfig(String[] protocols) {
        if (protocols != null) {
            this.syslogProtocols = new ArrayList<String>(protocols.length);
            for (int i = 0; i < protocols.length; ++i) {
                this.syslogProtocols.add(protocols[i]);
            }
        } else {
            this.syslogProtocols = Lists.newArrayList();
        }
    }

    public List<String> getProtocols() {
        return this.syslogProtocols;
    }

    public void addProtocol(String protocol) {
        this.syslogProtocols.add(protocol);
    }

    public void insertProtocol(int index2, String protocol) {
        this.syslogProtocols.add(index2, protocol);
    }

    public void removeProtocol(String protocol) {
        this.syslogProtocols.remove(protocol);
    }

    public void removeAllProtocols() {
        this.syslogProtocols.clear();
    }

    @Override
    public void addBackLogHandler(SyslogBackLogHandlerIF backLogHandler) {
        throw new SyslogRuntimeException("MultipleSyslog is an aggregator; please set the individual protocols", new Object[0]);
    }

    @Override
    public void addMessageModifier(SyslogMessageModifierIF messageModifier) {
        throw new SyslogRuntimeException("MultipleSyslog is an aggregator; please set the individual protocols", new Object[0]);
    }

    @Override
    public Class<? extends SyslogIF> getSyslogClass() {
        return MultipleSyslog.class;
    }

    @Override
    public Charset getCharSet() {
        return Charsets.UTF_8;
    }

    @Override
    public SyslogFacility getFacility() {
        return SyslogFacility.DEFAULT;
    }

    @Override
    public String getHost() {
        return "localhost";
    }

    @Override
    public String getIdent() {
        return null;
    }

    @Override
    public String getLocalName() {
        return null;
    }

    @Override
    public int getPort() {
        return 514;
    }

    public int getMaxShutdownWait() {
        return 30000;
    }

    public void setMaxShutdownWait(int maxShutdownWait) {
        throw new SyslogRuntimeException("MultipleSyslog is an aggregator; please set the individual protocols", new Object[0]);
    }

    @Override
    public void insertBackLogHandler(int index2, SyslogBackLogHandlerIF backLogHandler) {
        throw new SyslogRuntimeException("MultipleSyslog is an aggregator; please set the individual protocols", new Object[0]);
    }

    @Override
    public void insertMessageModifier(int index2, SyslogMessageModifierIF messageModifier) {
        throw new SyslogRuntimeException("MultipleSyslog is an aggregator; please set the individual protocols", new Object[0]);
    }

    public boolean isCacheHostAddress() {
        return true;
    }

    @Override
    public boolean isIncludeIdentInMessageModifier() {
        return false;
    }

    @Override
    public boolean isSendLocalName() {
        return true;
    }

    @Override
    public boolean isSendLocalTimestamp() {
        return true;
    }

    @Override
    public boolean isThrowExceptionOnInitialize() {
        return true;
    }

    @Override
    public boolean isThrowExceptionOnWrite() {
        return false;
    }

    @Override
    public void removeAllBackLogHandlers() {
        throw new SyslogRuntimeException("MultipleSyslog is an aggregator; please set the individual protocols", new Object[0]);
    }

    @Override
    public void removeAllMessageModifiers() {
        throw new SyslogRuntimeException("MultipleSyslog is an aggregator; please set the individual protocols", new Object[0]);
    }

    @Override
    public void removeBackLogHandler(SyslogBackLogHandlerIF backLogHandler) {
        throw new SyslogRuntimeException("MultipleSyslog is an aggregator; please set the individual protocols", new Object[0]);
    }

    @Override
    public void removeMessageModifier(SyslogMessageModifierIF messageModifier) {
        throw new SyslogRuntimeException("MultipleSyslog is an aggregator; please set the individual protocols", new Object[0]);
    }

    public void setCacheHostAddress(boolean cacheHostAddress) {
        throw new SyslogRuntimeException("MultipleSyslog is an aggregator; please set the individual protocols", new Object[0]);
    }

    @Override
    public void setCharSet(Charset charSet) {
        throw new SyslogRuntimeException("MultipleSyslog is an aggregator; please set the individual protocols", new Object[0]);
    }

    public void setFacility(int facility) {
        throw new SyslogRuntimeException("MultipleSyslog is an aggregator; please set the individual protocols", new Object[0]);
    }

    @Override
    public void setFacility(SyslogFacility facilityName) {
        throw new SyslogRuntimeException("MultipleSyslog is an aggregator; please set the individual protocols", new Object[0]);
    }

    @Override
    public void setHost(String host) throws SyslogRuntimeException {
        throw new SyslogRuntimeException("MultipleSyslog is an aggregator; please set the individual protocols", new Object[0]);
    }

    @Override
    public void setIdent(String ident2) {
        throw new SyslogRuntimeException("MultipleSyslog is an aggregator; please set the individual protocols", new Object[0]);
    }

    @Override
    public void setLocalName(String localName) {
        throw new SyslogRuntimeException("MultipleSyslog is an aggregator; please set the individual protocols", new Object[0]);
    }

    @Override
    public void setIncludeIdentInMessageModifier(boolean throwExceptionOnInitialize) {
        throw new SyslogRuntimeException("MultipleSyslog is an aggregator; please set the individual protocols", new Object[0]);
    }

    @Override
    public void setPort(int port) throws SyslogRuntimeException {
        throw new SyslogRuntimeException("MultipleSyslog is an aggregator; please set the individual protocols", new Object[0]);
    }

    @Override
    public void setSendLocalName(boolean sendLocalName) {
        throw new SyslogRuntimeException("MultipleSyslog is an aggregator; please set the individual protocols", new Object[0]);
    }

    @Override
    public void setSendLocalTimestamp(boolean sendLocalTimestamp) {
        throw new SyslogRuntimeException("MultipleSyslog is an aggregator; please set the individual protocols", new Object[0]);
    }

    @Override
    public void setThrowExceptionOnInitialize(boolean throwExceptionOnInitialize) {
        throw new SyslogRuntimeException("MultipleSyslog is an aggregator; please set the individual protocols", new Object[0]);
    }

    @Override
    public void setThrowExceptionOnWrite(boolean throwExceptionOnWrite) {
        throw new SyslogRuntimeException("MultipleSyslog is an aggregator; please set the individual protocols", new Object[0]);
    }

    @Override
    public int getMaxMessageLength() {
        return 1024;
    }

    @Override
    public void setMaxMessageLength(int maxMessageLength) {
        throw new SyslogRuntimeException("MultipleSyslog is an aggregator; please set the individual protocols", new Object[0]);
    }

    @Override
    public boolean isTruncateMessage() {
        return false;
    }

    @Override
    public void setTruncateMessage(boolean truncateMessage) {
        throw new SyslogRuntimeException("MultipleSyslog is an aggregator; please set the individual protocols", new Object[0]);
    }

    @Override
    public boolean isUseStructuredData() {
        return false;
    }

    @Override
    public void setUseStructuredData(boolean useStructuredData) {
        throw new SyslogRuntimeException("MultipleSyslog is an aggregator; please set the individual protocols", new Object[0]);
    }
}

