/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.syslog4j.impl.unix;

import com.google.common.collect.Maps;
import com.nesscomputing.syslog4j.SyslogFacility;
import com.nesscomputing.syslog4j.SyslogLevel;
import com.nesscomputing.syslog4j.SyslogMessageProcessorIF;
import com.nesscomputing.syslog4j.SyslogRuntimeException;
import com.nesscomputing.syslog4j.impl.AbstractSyslog;
import com.nesscomputing.syslog4j.impl.AbstractSyslogWriter;
import com.nesscomputing.syslog4j.impl.unix.UnixSyslogConfig;
import com.nesscomputing.syslog4j.util.OSDetectUtility;
import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class UnixSyslog
extends AbstractSyslog {
    protected UnixSyslogConfig unixSyslogConfig = null;
    private static SyslogFacility currentFacility = null;
    private static boolean openlogCalled = false;
    private static CLibrary libraryInstance = null;
    private static Map<String, Memory> identMap = Maps.newHashMap();

    protected static synchronized void loadLibrary(UnixSyslogConfig config) throws SyslogRuntimeException {
        if (!OSDetectUtility.isUnix()) {
            throw new SyslogRuntimeException("UnixSyslog not supported on non-Unix platforms", new Object[0]);
        }
        if (libraryInstance == null) {
            libraryInstance = (CLibrary)Native.loadLibrary((String)config.getLibrary(), CLibrary.class);
        }
    }

    private static void setOpenlogCalled() {
        openlogCalled = true;
    }

    @Override
    public void initialize() throws SyslogRuntimeException {
        try {
            this.unixSyslogConfig = (UnixSyslogConfig)this.syslogConfig;
        }
        catch (ClassCastException cce) {
            throw new SyslogRuntimeException("config must be of type UnixSyslogConfig", new Object[0]);
        }
        UnixSyslog.loadLibrary(this.unixSyslogConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void write(SyslogLevel level, String message, UnixSyslogConfig config) throws SyslogRuntimeException {
        CLibrary cLibrary = libraryInstance;
        synchronized (cLibrary) {
            if (currentFacility != config.getFacility()) {
                if (openlogCalled) {
                    libraryInstance.closelog();
                    openlogCalled = false;
                }
                currentFacility = config.getFacility();
            }
            if (!openlogCalled) {
                Memory identBuffer;
                String ident2 = config.getIdent();
                if (!StringUtils.isBlank(ident2)) {
                    ident2 = null;
                }
                Memory memory = identBuffer = ident2 == null ? null : identMap.get(ident2);
                if (ident2 != null && identBuffer == null) {
                    identBuffer = new Memory(128L);
                    identBuffer.setString(0L, ident2, false);
                    identMap.put(ident2, identBuffer);
                }
                libraryInstance.openlog(identBuffer, config.getOption(), currentFacility.getValue());
                openlogCalled = true;
            }
            int priority = (currentFacility == null ? 0 : currentFacility.getValue()) | (level == null ? 0 : level.getValue());
            libraryInstance.syslog(priority, "%s", message);
        }
    }

    @Override
    protected void write(SyslogLevel level, byte[] message) throws SyslogRuntimeException {
    }

    public void log(SyslogMessageProcessorIF messageProcessor, SyslogLevel level, String message) {
        UnixSyslog.write(level, message, this.unixSyslogConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws SyslogRuntimeException {
        CLibrary cLibrary = libraryInstance;
        synchronized (cLibrary) {
            libraryInstance.closelog();
            UnixSyslog.setOpenlogCalled();
        }
    }

    @Override
    public void shutdown() throws SyslogRuntimeException {
        this.flush();
    }

    @Override
    public AbstractSyslogWriter getWriter() {
        return null;
    }

    @Override
    public void returnWriter(AbstractSyslogWriter syslogWriter) {
    }

    protected static interface CLibrary
    extends Library {
        public void openlog(Memory var1, int var2, int var3);

        public void syslog(int var1, String var2, String var3);

        public void closelog();
    }
}

