/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.syslog4j.impl.unix.socket;

import com.google.common.base.Charsets;
import com.nesscomputing.syslog4j.SyslogLevel;
import com.nesscomputing.syslog4j.SyslogRuntimeException;
import com.nesscomputing.syslog4j.impl.AbstractSyslog;
import com.nesscomputing.syslog4j.impl.AbstractSyslogWriter;
import com.nesscomputing.syslog4j.impl.unix.socket.UnixSocketSyslogConfig;
import com.nesscomputing.syslog4j.util.OSDetectUtility;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Structure;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.ByteBuffer;

public class UnixSocketSyslog
extends AbstractSyslog {
    protected boolean libraryLoaded = false;
    private CLibrary libraryInstance = null;
    protected UnixSocketSyslogConfig unixSocketSyslogConfig = null;
    protected int fd = -1;

    protected synchronized void loadLibrary() {
        if (!OSDetectUtility.isUnix()) {
            throw new SyslogRuntimeException("UnixSyslog not supported on non-Unix platforms", new Object[0]);
        }
        if (!this.libraryLoaded) {
            this.libraryInstance = (CLibrary)Native.loadLibrary((String)this.unixSocketSyslogConfig.getLibrary(), CLibrary.class);
            this.libraryLoaded = true;
        }
    }

    @Override
    public void initialize() throws SyslogRuntimeException {
        try {
            this.unixSocketSyslogConfig = (UnixSocketSyslogConfig)this.syslogConfig;
        }
        catch (ClassCastException cce) {
            throw new SyslogRuntimeException("config must be of type UnixSocketSyslogConfig", new Object[0]);
        }
        this.loadLibrary();
    }

    protected synchronized void connect() {
        if (this.fd != -1) {
            return;
        }
        this.fd = this.libraryInstance.socket(this.unixSocketSyslogConfig.getFamily(), this.unixSocketSyslogConfig.getType(), this.unixSocketSyslogConfig.getProtocol());
        if (this.fd == -1) {
            this.fd = -1;
            return;
        }
        SockAddr sockAddr = new SockAddr();
        sockAddr.sun_family = this.unixSocketSyslogConfig.getFamily();
        sockAddr.setSunPath(this.unixSocketSyslogConfig.getPath());
        int c = this.libraryInstance.connect(this.fd, sockAddr, sockAddr.size());
        if (c == -1) {
            this.fd = -1;
            return;
        }
    }

    @Override
    protected synchronized void write(SyslogLevel level, byte[] message) throws SyslogRuntimeException {
        if (this.fd == -1) {
            this.connect();
        }
        if (this.fd == -1) {
            return;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(message);
        this.libraryInstance.write(this.fd, byteBuffer, message.length);
    }

    @Override
    public synchronized void flush() throws SyslogRuntimeException {
        this.shutdown();
        this.fd = this.libraryInstance.socket(this.unixSocketSyslogConfig.getFamily(), this.unixSocketSyslogConfig.getType(), this.unixSocketSyslogConfig.getProtocol());
    }

    @Override
    public synchronized void shutdown() throws SyslogRuntimeException {
        if (this.fd == -1) {
            return;
        }
        this.libraryInstance.close(this.fd);
        this.fd = -1;
    }

    @Override
    public AbstractSyslogWriter getWriter() {
        return null;
    }

    @Override
    public void returnWriter(AbstractSyslogWriter syslogWriter) {
    }

    protected static interface CLibrary
    extends Library {
        public int socket(int var1, int var2, int var3);

        public int connect(int var1, SockAddr var2, int var3);

        public int write(int var1, ByteBuffer var2, int var3);

        public int close(int var1);

        public String strerror(int var1);
    }

    protected static class SockAddr
    extends Structure {
        public static final int SUN_PATH_SIZE = 108;
        private static final byte[] ZERO_BYTE = new byte[]{0};
        @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
        public short sun_family = 1;
        public byte[] sun_path = new byte[108];

        protected SockAddr() {
        }

        public void setSunPath(String sunPath) {
            System.arraycopy(sunPath.getBytes(Charsets.UTF_8), 0, this.sun_path, 0, sunPath.length());
            System.arraycopy(ZERO_BYTE, 0, this.sun_path, sunPath.length(), 1);
        }
    }
}

