/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.syslog4j.impl.unix.socket;

import com.nesscomputing.syslog4j.SyslogFacility;
import com.nesscomputing.syslog4j.SyslogIF;
import com.nesscomputing.syslog4j.SyslogRuntimeException;
import com.nesscomputing.syslog4j.impl.AbstractSyslogConfig;
import com.nesscomputing.syslog4j.impl.unix.socket.UnixSocketSyslog;
import org.apache.commons.lang3.StringUtils;

public class UnixSocketSyslogConfig
extends AbstractSyslogConfig {
    protected int type = 2;
    protected short family = 1;
    protected int protocol = 0;
    protected String library = "c";
    protected String path = "/dev/log";

    public UnixSocketSyslogConfig() {
        this.setSendLocalName(false);
        this.setIdent("java");
    }

    @Override
    public Class<? extends SyslogIF> getSyslogClass() {
        return UnixSocketSyslog.class;
    }

    public UnixSocketSyslogConfig(SyslogFacility facility) {
        this.facility = facility;
    }

    public UnixSocketSyslogConfig(SyslogFacility facility, String path) {
        this.facility = facility;
        this.path = path;
    }

    public UnixSocketSyslogConfig(String path) {
        this.path = path;
    }

    @Override
    public String getHost() {
        return null;
    }

    @Override
    public int getPort() {
        return -1;
    }

    @Override
    public void setHost(String host) throws SyslogRuntimeException {
        throw new SyslogRuntimeException("Host not appropriate for class \"%s\"", this.getClass().getName());
    }

    @Override
    public void setPort(int port) throws SyslogRuntimeException {
        throw new SyslogRuntimeException("Port not appropriate for class \"%s\"", this.getClass().getName());
    }

    public String getLibrary() {
        return this.library;
    }

    public void setLibrary(String library) {
        this.library = library;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setType(String type) {
        if (type == null) {
            throw new SyslogRuntimeException("Type cannot be null for class \"%s\"", this.getClass().getName());
        }
        if ("SOCK_STREAM".equalsIgnoreCase(StringUtils.trimToEmpty(type))) {
            this.type = 1;
        } else if ("SOCK_DGRAM".equalsIgnoreCase(StringUtils.trimToEmpty(type))) {
            this.type = 2;
        } else {
            throw new SyslogRuntimeException("Type must be \"SOCK_STREAM\" or \"SOCK_DGRAM\" for class \"%s\"", this.getClass().getName());
        }
    }

    public short getFamily() {
        return this.family;
    }

    public void setFamily(short family) {
        this.family = family;
    }

    public void setFamily(String family) {
        if (family == null) {
            throw new SyslogRuntimeException("Family cannot be null for class \"%s\"", this.getClass().getName());
        }
        if (!"AF_UNIX".equalsIgnoreCase(StringUtils.trimToEmpty(family))) {
            throw new SyslogRuntimeException("Family must be \"AF_UNIX\" for class \"%s\"", this.getClass().getName());
        }
        this.family = 1;
    }

    public int getProtocol() {
        return this.protocol;
    }

    public void setProtocol(int protocol) {
        this.protocol = protocol;
    }

    @Override
    public int getMaxQueueSize() {
        return -1;
    }

    @Override
    public void setMaxQueueSize(int maxQueueSize) {
        throw new SyslogRuntimeException("UnixSyslog protocol does not uses a queueing mechanism", new Object[0]);
    }
}

