/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.syslog4j.server.impl;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.nesscomputing.syslog4j.server.SyslogServerConfigIF;
import com.nesscomputing.syslog4j.server.SyslogServerEventHandlerIF;
import com.nesscomputing.syslog4j.server.SyslogServerIF;
import java.nio.charset.Charset;
import java.util.List;

public abstract class AbstractSyslogServerConfig
implements SyslogServerConfigIF {
    protected Charset charSet = Charsets.UTF_8;
    protected long shutdownWait = 500L;
    protected List<SyslogServerEventHandlerIF> eventHandlers = Lists.newArrayList();
    protected boolean useStructuredData = false;
    protected Object dateTimeFormatter = null;
    protected boolean useDaemonThread = true;
    protected int threadPriority = -1;

    @Override
    public abstract Class<? extends SyslogServerIF> getSyslogServerClass();

    @Override
    public Charset getCharSet() {
        return this.charSet;
    }

    @Override
    public void setCharSet(Charset charSet) {
        this.charSet = charSet;
    }

    @Override
    public long getShutdownWait() {
        return this.shutdownWait;
    }

    @Override
    public void setShutdownWait(long shutdownWait) {
        this.shutdownWait = shutdownWait;
    }

    @Override
    public List<? extends SyslogServerEventHandlerIF> getEventHandlers() {
        return this.eventHandlers;
    }

    @Override
    public void addEventHandler(SyslogServerEventHandlerIF eventHandler) {
        this.eventHandlers.add(eventHandler);
    }

    @Override
    public void insertEventHandler(int pos, SyslogServerEventHandlerIF eventHandler) {
        this.eventHandlers.add(pos, eventHandler);
    }

    @Override
    public void removeEventHandler(SyslogServerEventHandlerIF eventHandler) {
        this.eventHandlers.remove(eventHandler);
    }

    @Override
    public void removeAllEventHandlers() {
        this.eventHandlers.clear();
    }

    @Override
    public boolean isUseStructuredData() {
        return this.useStructuredData;
    }

    @Override
    public void setUseStructuredData(boolean useStructuredData) {
        this.useStructuredData = useStructuredData;
    }

    @Override
    public boolean isUseDaemonThread() {
        return this.useDaemonThread;
    }

    @Override
    public Object getDateTimeFormatter() {
        return this.dateTimeFormatter;
    }

    @Override
    public void setDateTimeFormatter(Object dateTimeFormatter) {
        this.dateTimeFormatter = dateTimeFormatter;
    }

    @Override
    public void setUseDaemonThread(boolean useDaemonThread) {
        this.useDaemonThread = useDaemonThread;
    }

    @Override
    public int getThreadPriority() {
        return this.threadPriority;
    }

    @Override
    public void setThreadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
    }
}

