/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.syslog4j.server.impl.event;

import com.google.common.base.Charsets;
import com.nesscomputing.syslog4j.SyslogFacility;
import com.nesscomputing.syslog4j.SyslogLevel;
import com.nesscomputing.syslog4j.server.SyslogServerEventIF;
import com.nesscomputing.syslog4j.util.SyslogUtility;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SyslogServerEvent
implements SyslogServerEventIF {
    private static final Logger LOG = Logger.getLogger(SyslogServerEvent.class);
    public static final String DATE_FORMAT = "MMM dd HH:mm:ss yyyy";
    protected Charset charSet = Charsets.UTF_8;
    protected String rawString = null;
    protected byte[] rawBytes = null;
    protected int rawLength = -1;
    protected Date date = null;
    protected SyslogLevel level = SyslogLevel.INFO;
    protected SyslogFacility facility = SyslogFacility.user;
    protected String host = null;
    protected boolean isHostStrippedFromMessage = false;
    protected String message = null;
    protected InetAddress inetAddress = null;

    public SyslogServerEvent(String message, InetAddress inetAddress) {
        this.initialize(message, inetAddress);
    }

    public SyslogServerEvent(byte[] message, int length, InetAddress inetAddress) {
        this.initialize(message, length, inetAddress);
    }

    protected void initialize(String message, InetAddress inetAddress) {
        this.rawString = message;
        this.rawLength = message.length();
        this.inetAddress = inetAddress;
        this.message = message;
        this.parse();
    }

    protected void initialize(byte[] message, int length, InetAddress inetAddress) {
        this.rawBytes = message;
        this.rawLength = length;
        this.inetAddress = inetAddress;
        this.message = SyslogUtility.newString(this, this.rawBytes, this.rawLength);
        this.parse();
    }

    protected void parseHost() {
        int i = this.message.indexOf(32);
        if (i > -1) {
            String hostAddress = null;
            String hostName = null;
            String providedHost = StringUtils.trimToEmpty(this.message.substring(0, i));
            if (providedHost.equalsIgnoreCase(hostAddress = this.inetAddress.getHostAddress())) {
                this.host = hostAddress;
                this.message = this.message.substring(i + 1);
                this.isHostStrippedFromMessage = true;
            }
            if (this.host == null && !(hostName = this.inetAddress.getHostName()).equalsIgnoreCase(hostAddress)) {
                if (providedHost.equalsIgnoreCase(hostName)) {
                    this.host = hostName;
                    this.message = this.message.substring(i + 1);
                    this.isHostStrippedFromMessage = true;
                }
                if (this.host == null) {
                    int j = hostName.indexOf(46);
                    if (j > -1) {
                        hostName = hostName.substring(0, j);
                    }
                    if (providedHost.equalsIgnoreCase(hostName)) {
                        this.host = hostName;
                        this.message = this.message.substring(i + 1);
                        this.isHostStrippedFromMessage = true;
                    }
                }
            }
            if (this.host == null) {
                this.host = hostName != null ? hostName : hostAddress;
            }
        }
    }

    protected void parseDate() {
        if (this.message.length() >= 16 && this.message.charAt(3) == ' ' && this.message.charAt(6) == ' ') {
            String year = Integer.toString(Calendar.getInstance().get(1));
            String originalDate = this.message.substring(0, 15) + " " + year;
            SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
            try {
                this.date = dateFormat.parse(originalDate);
                this.message = this.message.substring(16);
            }
            catch (ParseException pe) {
                this.date = new Date();
            }
        }
    }

    protected void parsePriority() {
        int i;
        if (this.message.charAt(0) == '<' && (i = this.message.indexOf(">")) <= 4 && i > -1) {
            String priorityStr = this.message.substring(1, i);
            int priority = 0;
            try {
                priority = Integer.parseInt(priorityStr);
                this.facility = SyslogFacility.forValue(priority >> 3);
                this.level = SyslogLevel.values()[priority & 7];
                this.message = this.message.substring(i + 1);
            }
            catch (NumberFormatException nfe) {
                LOG.trace("While parsing priority", nfe);
            }
        }
    }

    protected void parse() {
        this.parsePriority();
        this.parseDate();
        this.parseHost();
    }

    @Override
    public SyslogFacility getFacility() {
        return this.facility;
    }

    @Override
    public void setFacility(SyslogFacility facility) {
        this.facility = facility;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public byte[] getRaw() {
        if (this.rawString != null) {
            byte[] rawStringBytes = SyslogUtility.getBytes(this, this.rawString);
            return rawStringBytes;
        }
        if (this.rawBytes.length == this.rawLength) {
            return this.rawBytes;
        }
        byte[] newRawBytes = new byte[this.rawLength];
        System.arraycopy(this.rawBytes, 0, newRawBytes, 0, this.rawLength);
        return newRawBytes;
    }

    public int getRawLength() {
        return this.rawLength;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public Date getDate() {
        return this.date;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public void setDate(Date date) {
        this.date = date;
    }

    @Override
    public SyslogLevel getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(SyslogLevel level) {
        this.level = level;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public void setHost(String host) {
        this.host = host;
    }

    @Override
    public boolean isHostStrippedFromMessage() {
        return this.isHostStrippedFromMessage;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public Charset getCharSet() {
        return this.charSet;
    }

    @Override
    public void setCharSet(Charset charSet) {
        this.charSet = charSet;
    }
}

