/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.tinyhttp;

import com.nesscomputing.tinyhttp.HttpContentConverter;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.commons.io.input.NullInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpContentResponseHandler<T> {
    private static final Logger log = LoggerFactory.getLogger(HttpContentResponseHandler.class);
    private final HttpContentConverter<T> contentConverter;

    public HttpContentResponseHandler(HttpContentConverter<T> contentConverter) {
        this.contentConverter = contentConverter;
    }

    public T handle(HttpRequest request, HttpResponse response) throws IOException {
        Header header;
        InputStream is = null;
        try {
            HttpEntity httpEntity = response.getEntity();
            if (httpEntity != null) {
                is = httpEntity.getContent();
            }
        }
        catch (IOException e) {
            log.warn("Could not locate response body stream", e);
        }
        if (is == null) {
            is = new NullInputStream(0L);
        }
        if ((header = response.getFirstHeader("Content-Encoding")) != null) {
            String encoding = StringUtils.trimToEmpty(header.getValue());
            if (StringUtils.equalsIgnoreCase(encoding, "gzip") || StringUtils.equalsIgnoreCase(encoding, "x-gzip")) {
                log.debug("Found GZIP stream");
                is = new GZIPInputStream(is);
            } else if (StringUtils.equalsIgnoreCase(encoding, "deflate")) {
                log.debug("Found deflate stream");
                Inflater inflater = new Inflater(true);
                is = new InflaterInputStream(is, inflater);
            }
        }
        return this.contentConverter.convert(request, response, is);
    }
}

