/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.tinyhttp;

import com.google.common.base.Throwables;
import com.google.common.io.Closeables;
import com.nesscomputing.tinyhttp.HttpContentConverter;
import com.nesscomputing.tinyhttp.HttpContentResponseHandler;
import com.nesscomputing.tinyhttp.HttpFetcherCredentialsProvider;
import com.nesscomputing.tinyhttp.ssl.HttpsTrustManagerFactory;
import com.nesscomputing.tinyhttp.ssl.SSLConfig;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.conn.SingleClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpFetcher
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(HttpFetcher.class);
    private final HttpParams params = new BasicHttpParams();
    private final SchemeRegistry registry = new SchemeRegistry();
    private final ClientConnectionManager connectionManager;
    private static final Scheme HTTP_SCHEME = new Scheme("http", 80, PlainSocketFactory.getSocketFactory());

    public HttpFetcher() {
        this(null);
    }

    public HttpFetcher(SSLConfig sslConfig) {
        this.params.setBooleanParameter("http.protocol.handle-redirects", true);
        this.registry.register(HTTP_SCHEME);
        if (sslConfig != null && sslConfig.isSSLEnabled()) {
            try {
                TrustManager[] trustManagers = new TrustManager[]{HttpsTrustManagerFactory.getTrustManager(sslConfig)};
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, trustManagers, null);
                SSLSocketFactory sslSocketFactory = new SSLSocketFactory(sslContext, SSLSocketFactory.STRICT_HOSTNAME_VERIFIER);
                this.registry.register(new Scheme("https", 443, sslSocketFactory));
                LOG.debug("HTTPS enabled.");
            }
            catch (GeneralSecurityException ce) {
                throw Throwables.propagate(ce);
            }
            catch (IOException ioe) {
                throw Throwables.propagate(ioe);
            }
        } else {
            LOG.debug("HTTPS disabled.");
        }
        this.connectionManager = new SingleClientConnManager(this.registry);
        LOG.debug("HTTP fetcher ready.");
    }

    @Override
    public void close() {
        this.connectionManager.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T get(URI uri, String login, String pw, HttpContentConverter<T> converter) throws IOException {
        HttpGet httpRequest = new HttpGet(uri);
        DefaultHttpClient httpClient = new DefaultHttpClient(this.connectionManager, this.params);
        httpClient.setHttpRequestRetryHandler(new DefaultHttpRequestRetryHandler(3, false));
        if (login != null) {
            httpClient.setCredentialsProvider(new HttpFetcherCredentialsProvider(login, pw));
        }
        HttpContentResponseHandler<T> responseHandler = new HttpContentResponseHandler<T>(converter);
        try {
            BasicHttpContext httpContext = new BasicHttpContext();
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpRequest, httpContext);
            try {
                T t = responseHandler.handle(httpRequest, httpResponse);
                return t;
            }
            finally {
                HttpEntity entity = httpResponse.getEntity();
                if (entity != null) {
                    Closeables.closeQuietly((Closeable)entity.getContent());
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Aborting Request!", e);
            httpRequest.abort();
            throw Throwables.propagate(e);
        }
    }
}

