/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.util;

import java.util.concurrent.TimeUnit;

public final class Sizes {
    private Sizes() {
    }

    public static String formatSize(long count2) {
        return Sizes.humanReadableByteCount(count2, false);
    }

    public static String formatRate(long count2, long time, TimeUnit units) {
        double rate = (double)count2 * 1000.0;
        return Sizes.formatSize((long)(rate /= (double)TimeUnit.MILLISECONDS.convert(time, units))) + "/s";
    }

    private static String humanReadableByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }
}

