/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp;

import com.squareup.okhttp.OkAuthenticator;
import com.squareup.okhttp.Protocol;
import com.squareup.okhttp.internal.Util;
import java.net.Proxy;
import java.net.UnknownHostException;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;

public final class Address {
    final Proxy proxy;
    final String uriHost;
    final int uriPort;
    final SSLSocketFactory sslSocketFactory;
    final HostnameVerifier hostnameVerifier;
    final OkAuthenticator authenticator;
    final List<Protocol> protocols;

    public Address(String uriHost, int uriPort, SSLSocketFactory sslSocketFactory, HostnameVerifier hostnameVerifier, OkAuthenticator authenticator, Proxy proxy, List<Protocol> protocols) throws UnknownHostException {
        if (uriHost == null) {
            throw new NullPointerException("uriHost == null");
        }
        if (uriPort <= 0) {
            throw new IllegalArgumentException("uriPort <= 0: " + uriPort);
        }
        if (authenticator == null) {
            throw new IllegalArgumentException("authenticator == null");
        }
        if (protocols == null) {
            throw new IllegalArgumentException("protocols == null");
        }
        this.proxy = proxy;
        this.uriHost = uriHost;
        this.uriPort = uriPort;
        this.sslSocketFactory = sslSocketFactory;
        this.hostnameVerifier = hostnameVerifier;
        this.authenticator = authenticator;
        this.protocols = Util.immutableList(protocols);
    }

    public String getUriHost() {
        return this.uriHost;
    }

    public int getUriPort() {
        return this.uriPort;
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public OkAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    public List<Protocol> getProtocols() {
        return this.protocols;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public boolean equals(Object other) {
        if (other instanceof Address) {
            Address that = (Address)other;
            return Util.equal(this.proxy, that.proxy) && this.uriHost.equals(that.uriHost) && this.uriPort == that.uriPort && Util.equal(this.sslSocketFactory, that.sslSocketFactory) && Util.equal(this.hostnameVerifier, that.hostnameVerifier) && Util.equal(this.authenticator, that.authenticator) && Util.equal(this.protocols, that.protocols);
        }
        return false;
    }

    public int hashCode() {
        int result2 = 17;
        result2 = 31 * result2 + this.uriHost.hashCode();
        result2 = 31 * result2 + this.uriPort;
        result2 = 31 * result2 + (this.sslSocketFactory != null ? this.sslSocketFactory.hashCode() : 0);
        result2 = 31 * result2 + (this.hostnameVerifier != null ? this.hostnameVerifier.hashCode() : 0);
        result2 = 31 * result2 + (this.authenticator != null ? this.authenticator.hashCode() : 0);
        result2 = 31 * result2 + (this.proxy != null ? this.proxy.hashCode() : 0);
        result2 = 31 * result2 + this.protocols.hashCode();
        return result2;
    }
}

