/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp;

import com.squareup.okhttp.internal.http.HeaderParser;
import com.squareup.okhttp.internal.http.Headers;

public final class CacheControl {
    private final boolean noCache;
    private final boolean noStore;
    private final int maxAgeSeconds;
    private final int sMaxAgeSeconds;
    private final boolean isPublic;
    private final boolean mustRevalidate;
    private final int maxStaleSeconds;
    private final int minFreshSeconds;
    private final boolean onlyIfCached;

    private CacheControl(boolean noCache, boolean noStore, int maxAgeSeconds, int sMaxAgeSeconds, boolean isPublic, boolean mustRevalidate, int maxStaleSeconds, int minFreshSeconds, boolean onlyIfCached) {
        this.noCache = noCache;
        this.noStore = noStore;
        this.maxAgeSeconds = maxAgeSeconds;
        this.sMaxAgeSeconds = sMaxAgeSeconds;
        this.isPublic = isPublic;
        this.mustRevalidate = mustRevalidate;
        this.maxStaleSeconds = maxStaleSeconds;
        this.minFreshSeconds = minFreshSeconds;
        this.onlyIfCached = onlyIfCached;
    }

    public boolean noCache() {
        return this.noCache;
    }

    public boolean noStore() {
        return this.noStore;
    }

    public int maxAgeSeconds() {
        return this.maxAgeSeconds;
    }

    public int sMaxAgeSeconds() {
        return this.sMaxAgeSeconds;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public boolean mustRevalidate() {
        return this.mustRevalidate;
    }

    public int maxStaleSeconds() {
        return this.maxStaleSeconds;
    }

    public int minFreshSeconds() {
        return this.minFreshSeconds;
    }

    public boolean onlyIfCached() {
        return this.onlyIfCached;
    }

    public static CacheControl parse(Headers headers) {
        boolean noCache = false;
        boolean noStore = false;
        int maxAgeSeconds = -1;
        int sMaxAgeSeconds = -1;
        boolean isPublic = false;
        boolean mustRevalidate = false;
        int maxStaleSeconds = -1;
        int minFreshSeconds = -1;
        boolean onlyIfCached = false;
        for (int i = 0; i < headers.size(); ++i) {
            if (!headers.name(i).equalsIgnoreCase("Cache-Control") && !headers.name(i).equalsIgnoreCase("Pragma")) continue;
            String string2 = headers.value(i);
            int pos = 0;
            while (pos < string2.length()) {
                String parameter;
                int tokenStart = pos;
                pos = HeaderParser.skipUntil(string2, pos, "=,;");
                String directive = string2.substring(tokenStart, pos).trim();
                if (pos == string2.length() || string2.charAt(pos) == ',' || string2.charAt(pos) == ';') {
                    ++pos;
                    parameter = null;
                } else {
                    int parameterStart;
                    ++pos;
                    if ((pos = HeaderParser.skipWhitespace(string2, pos)) < string2.length() && string2.charAt(pos) == '\"') {
                        parameterStart = ++pos;
                        pos = HeaderParser.skipUntil(string2, pos, "\"");
                        parameter = string2.substring(parameterStart, pos);
                        ++pos;
                    } else {
                        parameterStart = pos;
                        pos = HeaderParser.skipUntil(string2, pos, ",;");
                        parameter = string2.substring(parameterStart, pos).trim();
                    }
                }
                if ("no-cache".equalsIgnoreCase(directive)) {
                    noCache = true;
                    continue;
                }
                if ("no-store".equalsIgnoreCase(directive)) {
                    noStore = true;
                    continue;
                }
                if ("max-age".equalsIgnoreCase(directive)) {
                    maxAgeSeconds = HeaderParser.parseSeconds(parameter);
                    continue;
                }
                if ("s-maxage".equalsIgnoreCase(directive)) {
                    sMaxAgeSeconds = HeaderParser.parseSeconds(parameter);
                    continue;
                }
                if ("public".equalsIgnoreCase(directive)) {
                    isPublic = true;
                    continue;
                }
                if ("must-revalidate".equalsIgnoreCase(directive)) {
                    mustRevalidate = true;
                    continue;
                }
                if ("max-stale".equalsIgnoreCase(directive)) {
                    maxStaleSeconds = HeaderParser.parseSeconds(parameter);
                    continue;
                }
                if ("min-fresh".equalsIgnoreCase(directive)) {
                    minFreshSeconds = HeaderParser.parseSeconds(parameter);
                    continue;
                }
                if (!"only-if-cached".equalsIgnoreCase(directive)) continue;
                onlyIfCached = true;
            }
        }
        return new CacheControl(noCache, noStore, maxAgeSeconds, sMaxAgeSeconds, isPublic, mustRevalidate, maxStaleSeconds, minFreshSeconds, onlyIfCached);
    }
}

