/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp;

import com.squareup.okhttp.ConnectionPool;
import com.squareup.okhttp.OkAuthenticator;
import com.squareup.okhttp.OkResponseCache;
import com.squareup.okhttp.Protocol;
import com.squareup.okhttp.RouteDatabase;
import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.http.HttpAuthenticator;
import com.squareup.okhttp.internal.http.HttpURLConnectionImpl;
import com.squareup.okhttp.internal.http.HttpsURLConnectionImpl;
import com.squareup.okhttp.internal.http.ResponseCacheAdapter;
import com.squareup.okhttp.internal.okio.ByteString;
import com.squareup.okhttp.internal.tls.OkHostnameVerifier;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.ResponseCache;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

public final class OkHttpClient
implements URLStreamHandlerFactory,
Cloneable {
    private final RouteDatabase routeDatabase = new RouteDatabase();
    private Proxy proxy;
    private List<Protocol> protocols;
    private ProxySelector proxySelector;
    private CookieHandler cookieHandler;
    private OkResponseCache responseCache;
    private SSLSocketFactory sslSocketFactory;
    private HostnameVerifier hostnameVerifier;
    private OkAuthenticator authenticator;
    private ConnectionPool connectionPool;
    private boolean followProtocolRedirects = true;
    private int connectTimeout;
    private int readTimeout;

    public void setConnectTimeout(long timeout, TimeUnit unit) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout < 0");
        }
        if (unit == null) {
            throw new IllegalArgumentException("unit == null");
        }
        long millis = unit.toMillis(timeout);
        if (millis > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Timeout too large.");
        }
        this.connectTimeout = (int)millis;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setReadTimeout(long timeout, TimeUnit unit) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout < 0");
        }
        if (unit == null) {
            throw new IllegalArgumentException("unit == null");
        }
        long millis = unit.toMillis(timeout);
        if (millis > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Timeout too large.");
        }
        this.readTimeout = (int)millis;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public OkHttpClient setProxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public OkHttpClient setProxySelector(ProxySelector proxySelector) {
        this.proxySelector = proxySelector;
        return this;
    }

    public ProxySelector getProxySelector() {
        return this.proxySelector;
    }

    public OkHttpClient setCookieHandler(CookieHandler cookieHandler) {
        this.cookieHandler = cookieHandler;
        return this;
    }

    public CookieHandler getCookieHandler() {
        return this.cookieHandler;
    }

    public OkHttpClient setResponseCache(ResponseCache responseCache) {
        return this.setOkResponseCache(this.toOkResponseCache(responseCache));
    }

    public ResponseCache getResponseCache() {
        return this.responseCache instanceof ResponseCacheAdapter ? ((ResponseCacheAdapter)this.responseCache).getDelegate() : null;
    }

    public OkHttpClient setOkResponseCache(OkResponseCache responseCache) {
        this.responseCache = responseCache;
        return this;
    }

    public OkResponseCache getOkResponseCache() {
        return this.responseCache;
    }

    public OkHttpClient setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
        return this;
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public OkHttpClient setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
        return this;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public OkHttpClient setAuthenticator(OkAuthenticator authenticator) {
        this.authenticator = authenticator;
        return this;
    }

    public OkAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    public OkHttpClient setConnectionPool(ConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
        return this;
    }

    public ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    public OkHttpClient setFollowProtocolRedirects(boolean followProtocolRedirects) {
        this.followProtocolRedirects = followProtocolRedirects;
        return this;
    }

    public boolean getFollowProtocolRedirects() {
        return this.followProtocolRedirects;
    }

    public RouteDatabase getRoutesDatabase() {
        return this.routeDatabase;
    }

    @Deprecated
    public OkHttpClient setTransports(List<String> transports) {
        ArrayList<Protocol> protocols = new ArrayList<Protocol>(transports.size());
        int size2 = transports.size();
        for (int i = 0; i < size2; ++i) {
            try {
                Protocol protocol = Util.getProtocol(ByteString.encodeUtf8(transports.get(i)));
                protocols.add(protocol);
                continue;
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return this.setProtocols(protocols);
    }

    public OkHttpClient setProtocols(List<Protocol> protocols) {
        if (!(protocols = Util.immutableList(protocols)).contains((Object)Protocol.HTTP_11)) {
            throw new IllegalArgumentException("protocols doesn't contain http/1.1: " + protocols);
        }
        if (protocols.contains(null)) {
            throw new IllegalArgumentException("protocols must not contain null");
        }
        this.protocols = Util.immutableList(protocols);
        return this;
    }

    @Deprecated
    public List<String> getTransports() {
        ArrayList<String> transports = new ArrayList<String>(this.protocols.size());
        int size2 = this.protocols.size();
        for (int i = 0; i < size2; ++i) {
            transports.add(this.protocols.get((int)i).name.utf8());
        }
        return transports;
    }

    public List<Protocol> getProtocols() {
        return this.protocols;
    }

    public HttpURLConnection open(URL url) {
        return this.open(url, this.proxy);
    }

    HttpURLConnection open(URL url, Proxy proxy) {
        String protocol = url.getProtocol();
        OkHttpClient copy = this.copyWithDefaults();
        copy.proxy = proxy;
        if (protocol.equals("http")) {
            return new HttpURLConnectionImpl(url, copy);
        }
        if (protocol.equals("https")) {
            return new HttpsURLConnectionImpl(url, copy);
        }
        throw new IllegalArgumentException("Unexpected protocol: " + protocol);
    }

    OkHttpClient copyWithDefaults() {
        OkHttpClient result2 = this.clone();
        if (result2.proxySelector == null) {
            result2.proxySelector = ProxySelector.getDefault();
        }
        if (result2.cookieHandler == null) {
            result2.cookieHandler = CookieHandler.getDefault();
        }
        if (result2.responseCache == null) {
            result2.responseCache = this.toOkResponseCache(ResponseCache.getDefault());
        }
        if (result2.sslSocketFactory == null) {
            result2.sslSocketFactory = this.getDefaultSSLSocketFactory();
        }
        if (result2.hostnameVerifier == null) {
            result2.hostnameVerifier = OkHostnameVerifier.INSTANCE;
        }
        if (result2.authenticator == null) {
            result2.authenticator = HttpAuthenticator.SYSTEM_DEFAULT;
        }
        if (result2.connectionPool == null) {
            result2.connectionPool = ConnectionPool.getDefault();
        }
        if (result2.protocols == null) {
            result2.protocols = Util.HTTP2_SPDY3_AND_HTTP;
        }
        return result2;
    }

    private synchronized SSLSocketFactory getDefaultSSLSocketFactory() {
        if (this.sslSocketFactory == null) {
            try {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, null, null);
                this.sslSocketFactory = sslContext.getSocketFactory();
            }
            catch (GeneralSecurityException e) {
                throw new AssertionError();
            }
        }
        return this.sslSocketFactory;
    }

    public OkHttpClient clone() {
        try {
            return (OkHttpClient)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    private OkResponseCache toOkResponseCache(ResponseCache responseCache) {
        return responseCache == null || responseCache instanceof OkResponseCache ? (OkResponseCache)((Object)responseCache) : new ResponseCacheAdapter(responseCache);
    }

    @Override
    public URLStreamHandler createURLStreamHandler(final String protocol) {
        if (!protocol.equals("http") && !protocol.equals("https")) {
            return null;
        }
        return new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL url) {
                return OkHttpClient.this.open(url);
            }

            @Override
            protected URLConnection openConnection(URL url, Proxy proxy) {
                return OkHttpClient.this.open(url, proxy);
            }

            @Override
            protected int getDefaultPort() {
                if (protocol.equals("http")) {
                    return 80;
                }
                if (protocol.equals("https")) {
                    return 443;
                }
                throw new AssertionError();
            }
        };
    }
}

