/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp;

import com.squareup.okhttp.Address;
import java.net.InetSocketAddress;
import java.net.Proxy;

public class Route {
    final Address address;
    final Proxy proxy;
    final InetSocketAddress inetSocketAddress;
    final boolean modernTls;

    public Route(Address address, Proxy proxy, InetSocketAddress inetSocketAddress, boolean modernTls) {
        if (address == null) {
            throw new NullPointerException("address == null");
        }
        if (proxy == null) {
            throw new NullPointerException("proxy == null");
        }
        if (inetSocketAddress == null) {
            throw new NullPointerException("inetSocketAddress == null");
        }
        this.address = address;
        this.proxy = proxy;
        this.inetSocketAddress = inetSocketAddress;
        this.modernTls = modernTls;
    }

    public Address getAddress() {
        return this.address;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public InetSocketAddress getSocketAddress() {
        return this.inetSocketAddress;
    }

    public boolean isModernTls() {
        return this.modernTls;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Route) {
            Route other = (Route)obj;
            return this.address.equals(other.address) && this.proxy.equals(other.proxy) && this.inetSocketAddress.equals(other.inetSocketAddress) && this.modernTls == other.modernTls;
        }
        return false;
    }

    public int hashCode() {
        int result2 = 17;
        result2 = 31 * result2 + this.address.hashCode();
        result2 = 31 * result2 + this.proxy.hashCode();
        result2 = 31 * result2 + this.inetSocketAddress.hashCode();
        return result2 += this.modernTls ? 31 * result2 : 0;
    }
}

