/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal;

import com.squareup.okhttp.Protocol;
import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.okio.ByteString;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.net.ssl.SSLSocket;

public class Platform {
    private static final Platform PLATFORM = Platform.findPlatform();
    private Constructor<DeflaterOutputStream> deflaterConstructor;

    public static Platform get() {
        return PLATFORM;
    }

    public String getPrefix() {
        return "OkHttp";
    }

    public void logW(String warning) {
        System.out.println(warning);
    }

    public void tagSocket(Socket socket) throws SocketException {
    }

    public void untagSocket(Socket socket) throws SocketException {
    }

    public URI toUriLenient(URL url) throws URISyntaxException {
        return url.toURI();
    }

    public void enableTlsExtensions(SSLSocket socket, String uriHost) {
    }

    public void supportTlsIntolerantServer(SSLSocket socket) {
        socket.setEnabledProtocols(new String[]{"SSLv3"});
    }

    public ByteString getNpnSelectedProtocol(SSLSocket socket) {
        return null;
    }

    public void setNpnProtocols(SSLSocket socket, List<Protocol> npnProtocols) {
    }

    public void connectSocket(Socket socket, InetSocketAddress address, int connectTimeout) throws IOException {
        socket.connect(address, connectTimeout);
    }

    public OutputStream newDeflaterOutputStream(OutputStream out, Deflater deflater, boolean syncFlush) {
        try {
            Constructor<DeflaterOutputStream> constructor = this.deflaterConstructor;
            if (constructor == null) {
                constructor = this.deflaterConstructor = DeflaterOutputStream.class.getConstructor(OutputStream.class, Deflater.class, Boolean.TYPE);
            }
            return constructor.newInstance(out, deflater, syncFlush);
        }
        catch (NoSuchMethodException e) {
            throw new UnsupportedOperationException("Cannot SPDY; no SYNC_FLUSH available");
        }
        catch (InvocationTargetException e) {
            throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause());
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError();
        }
    }

    private static Platform findPlatform() {
        try {
            Class<?> openSslSocketClass;
            try {
                openSslSocketClass = Class.forName("com.android.org.conscrypt.OpenSSLSocketImpl");
            }
            catch (ClassNotFoundException ignored) {
                openSslSocketClass = Class.forName("org.apache.harmony.xnet.provider.jsse.OpenSSLSocketImpl");
            }
            Method setUseSessionTickets = openSslSocketClass.getMethod("setUseSessionTickets", Boolean.TYPE);
            Method setHostname = openSslSocketClass.getMethod("setHostname", String.class);
            Method setNpnProtocols = null;
            Method getNpnSelectedProtocol = null;
            try {
                setNpnProtocols = openSslSocketClass.getMethod("setNpnProtocols", byte[].class);
                getNpnSelectedProtocol = openSslSocketClass.getMethod("getNpnSelectedProtocol", new Class[0]);
            }
            catch (NoSuchMethodException ignored) {
                // empty catch block
            }
            return new Android(openSslSocketClass, setUseSessionTickets, setHostname, setNpnProtocols, getNpnSelectedProtocol);
        }
        catch (ClassNotFoundException ignored) {
        }
        catch (NoSuchMethodException ignored) {
            // empty catch block
        }
        try {
            String npnClassName = "org.eclipse.jetty.npn.NextProtoNego";
            Class<?> nextProtoNegoClass = Class.forName(npnClassName);
            Class<?> providerClass = Class.forName(npnClassName + "$Provider");
            Class<?> clientProviderClass = Class.forName(npnClassName + "$ClientProvider");
            Class<?> serverProviderClass = Class.forName(npnClassName + "$ServerProvider");
            Method putMethod = nextProtoNegoClass.getMethod("put", SSLSocket.class, providerClass);
            Method getMethod = nextProtoNegoClass.getMethod("get", SSLSocket.class);
            return new JdkWithJettyNpnPlatform(putMethod, getMethod, clientProviderClass, serverProviderClass);
        }
        catch (ClassNotFoundException ignored) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return new Platform();
    }

    static byte[] concatLengthPrefixed(List<Protocol> protocols) {
        int size2 = 0;
        for (Protocol protocol : protocols) {
            size2 += protocol.name.size() + 1;
        }
        byte[] result2 = new byte[size2];
        int pos = 0;
        for (Protocol protocol : protocols) {
            int nameSize = protocol.name.size();
            result2[pos++] = (byte)nameSize;
            System.arraycopy(protocol.name.toByteArray(), 0, result2, pos, nameSize);
            pos += nameSize;
        }
        return result2;
    }

    private static class JettyNpnProvider
    implements InvocationHandler {
        private final List<String> protocols;
        private boolean unsupported;
        private String selected;

        public JettyNpnProvider(List<String> protocols) {
            this.protocols = protocols;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            Class<?> returnType = method.getReturnType();
            if (args == null) {
                args = Util.EMPTY_STRING_ARRAY;
            }
            if (methodName.equals("supports") && Boolean.TYPE == returnType) {
                return true;
            }
            if (methodName.equals("unsupported") && Void.TYPE == returnType) {
                this.unsupported = true;
                return null;
            }
            if (methodName.equals("protocols") && args.length == 0) {
                return this.protocols;
            }
            if (methodName.equals("selectProtocol") && String.class == returnType && args.length == 1 && (args[0] == null || args[0] instanceof List)) {
                List serverProtocols = (List)args[0];
                int size2 = serverProtocols.size();
                for (int i = 0; i < size2; ++i) {
                    if (!this.protocols.contains(serverProtocols.get(i))) continue;
                    this.selected = (String)serverProtocols.get(i);
                    return this.selected;
                }
                this.selected = this.protocols.get(0);
                return this.selected;
            }
            if (methodName.equals("protocolSelected") && args.length == 1) {
                this.selected = (String)args[0];
                return null;
            }
            return method.invoke((Object)this, args);
        }
    }

    private static class JdkWithJettyNpnPlatform
    extends Platform {
        private final Method getMethod;
        private final Method putMethod;
        private final Class<?> clientProviderClass;
        private final Class<?> serverProviderClass;

        public JdkWithJettyNpnPlatform(Method putMethod, Method getMethod, Class<?> clientProviderClass, Class<?> serverProviderClass) {
            this.putMethod = putMethod;
            this.getMethod = getMethod;
            this.clientProviderClass = clientProviderClass;
            this.serverProviderClass = serverProviderClass;
        }

        @Override
        public void setNpnProtocols(SSLSocket socket, List<Protocol> npnProtocols) {
            try {
                ArrayList<String> names = new ArrayList<String>(npnProtocols.size());
                int size2 = npnProtocols.size();
                for (int i = 0; i < size2; ++i) {
                    names.add(npnProtocols.get((int)i).name.utf8());
                }
                Object provider = Proxy.newProxyInstance(Platform.class.getClassLoader(), new Class[]{this.clientProviderClass, this.serverProviderClass}, (InvocationHandler)new JettyNpnProvider(names));
                this.putMethod.invoke(null, socket, provider);
            }
            catch (InvocationTargetException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public ByteString getNpnSelectedProtocol(SSLSocket socket) {
            try {
                JettyNpnProvider provider = (JettyNpnProvider)Proxy.getInvocationHandler(this.getMethod.invoke(null, socket));
                if (!provider.unsupported && provider.selected == null) {
                    Logger logger = Logger.getLogger("com.squareup.okhttp.OkHttpClient");
                    logger.log(Level.INFO, "NPN callback dropped so SPDY is disabled. Is npn-boot on the boot class path?");
                    return null;
                }
                return provider.unsupported ? null : ByteString.encodeUtf8(provider.selected);
            }
            catch (InvocationTargetException e) {
                throw new AssertionError();
            }
            catch (IllegalAccessException e) {
                throw new AssertionError();
            }
        }
    }

    private static class Android
    extends Platform {
        protected final Class<?> openSslSocketClass;
        private final Method setUseSessionTickets;
        private final Method setHostname;
        private final Method setNpnProtocols;
        private final Method getNpnSelectedProtocol;

        private Android(Class<?> openSslSocketClass, Method setUseSessionTickets, Method setHostname, Method setNpnProtocols, Method getNpnSelectedProtocol) {
            this.openSslSocketClass = openSslSocketClass;
            this.setUseSessionTickets = setUseSessionTickets;
            this.setHostname = setHostname;
            this.setNpnProtocols = setNpnProtocols;
            this.getNpnSelectedProtocol = getNpnSelectedProtocol;
        }

        @Override
        public void connectSocket(Socket socket, InetSocketAddress address, int connectTimeout) throws IOException {
            try {
                socket.connect(address, connectTimeout);
            }
            catch (SecurityException se) {
                IOException ioException = new IOException("Exception in connect");
                ioException.initCause(se);
                throw ioException;
            }
        }

        @Override
        public void enableTlsExtensions(SSLSocket socket, String uriHost) {
            super.enableTlsExtensions(socket, uriHost);
            if (!this.openSslSocketClass.isInstance(socket)) {
                return;
            }
            try {
                this.setUseSessionTickets.invoke((Object)socket, true);
                this.setHostname.invoke((Object)socket, uriHost);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public void setNpnProtocols(SSLSocket socket, List<Protocol> npnProtocols) {
            if (this.setNpnProtocols == null) {
                return;
            }
            if (!this.openSslSocketClass.isInstance(socket)) {
                return;
            }
            try {
                Object[] parameters = new Object[]{Android.concatLengthPrefixed(npnProtocols)};
                this.setNpnProtocols.invoke((Object)socket, parameters);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public ByteString getNpnSelectedProtocol(SSLSocket socket) {
            if (this.getNpnSelectedProtocol == null) {
                return null;
            }
            if (!this.openSslSocketClass.isInstance(socket)) {
                return null;
            }
            try {
                byte[] npnResult = (byte[])this.getNpnSelectedProtocol.invoke((Object)socket, new Object[0]);
                if (npnResult == null) {
                    return null;
                }
                return ByteString.of(npnResult);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

