/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal;

import com.squareup.okhttp.Protocol;
import com.squareup.okhttp.internal.okio.ByteString;
import com.squareup.okhttp.internal.okio.OkBuffer;
import com.squareup.okhttp.internal.okio.Source;
import com.squareup.okhttp.internal.spdy.Header;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public final class Util {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final InputStream EMPTY_INPUT_STREAM = new ByteArrayInputStream(EMPTY_BYTE_ARRAY);
    public static final Charset US_ASCII = Charset.forName("US-ASCII");
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final List<Protocol> HTTP2_SPDY3_AND_HTTP = Util.immutableList(Arrays.asList(Protocol.HTTP_2, Protocol.SPDY_3, Protocol.HTTP_11));
    public static final List<Protocol> SPDY3_AND_HTTP11 = Util.immutableList(Arrays.asList(Protocol.SPDY_3, Protocol.HTTP_11));
    public static final List<Protocol> HTTP2_AND_HTTP_11 = Util.immutableList(Arrays.asList(Protocol.HTTP_2, Protocol.HTTP_11));

    private Util() {
    }

    public static int getEffectivePort(URI uri) {
        return Util.getEffectivePort(uri.getScheme(), uri.getPort());
    }

    public static int getEffectivePort(URL url) {
        return Util.getEffectivePort(url.getProtocol(), url.getPort());
    }

    private static int getEffectivePort(String scheme, int specifiedPort) {
        return specifiedPort != -1 ? specifiedPort : Util.getDefaultPort(scheme);
    }

    public static int getDefaultPort(String protocol) {
        if ("http".equals(protocol)) {
            return 80;
        }
        if ("https".equals(protocol)) {
            return 443;
        }
        return -1;
    }

    public static void checkOffsetAndCount(long arrayLength, long offset, long count2) {
        if ((offset | count2) < 0L || offset > arrayLength || arrayLength - offset < count2) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public static boolean equal(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (RuntimeException rethrown) {
                throw rethrown;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (RuntimeException rethrown) {
                throw rethrown;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(ServerSocket serverSocket) {
        if (serverSocket != null) {
            try {
                serverSocket.close();
            }
            catch (RuntimeException rethrown) {
                throw rethrown;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeAll(Closeable a, Closeable b) throws IOException {
        Throwable thrown;
        block8: {
            thrown = null;
            try {
                a.close();
            }
            catch (Throwable e) {
                thrown = e;
            }
            try {
                b.close();
            }
            catch (Throwable e) {
                if (thrown != null) break block8;
                thrown = e;
            }
        }
        if (thrown == null) {
            return;
        }
        if (thrown instanceof IOException) {
            throw (IOException)thrown;
        }
        if (thrown instanceof RuntimeException) {
            throw (RuntimeException)thrown;
        }
        if (thrown instanceof Error) {
            throw (Error)thrown;
        }
        throw new AssertionError((Object)thrown);
    }

    public static void deleteContents(File dir) throws IOException {
        File[] files = dir.listFiles();
        if (files == null) {
            throw new IOException("not a readable directory: " + dir);
        }
        for (File file : files) {
            if (file.isDirectory()) {
                Util.deleteContents(file);
            }
            if (file.delete()) continue;
            throw new IOException("failed to delete file: " + file);
        }
    }

    public static void readFully(InputStream in, byte[] dst) throws IOException {
        Util.readFully(in, dst, 0, dst.length);
    }

    public static void readFully(InputStream in, byte[] dst, int offset, int byteCount) throws IOException {
        if (byteCount == 0) {
            return;
        }
        if (in == null) {
            throw new NullPointerException("in == null");
        }
        if (dst == null) {
            throw new NullPointerException("dst == null");
        }
        Util.checkOffsetAndCount(dst.length, offset, byteCount);
        while (byteCount > 0) {
            int bytesRead = in.read(dst, offset, byteCount);
            if (bytesRead < 0) {
                throw new EOFException();
            }
            offset += bytesRead;
            byteCount -= bytesRead;
        }
    }

    public static OkBuffer readFully(Source source) throws IOException {
        OkBuffer result2 = new OkBuffer();
        while (source.read(result2, 2048L) != -1L) {
        }
        source.close();
        return result2;
    }

    public static boolean skipAll(Source in, int timeoutMillis) throws IOException {
        long startNanos = System.nanoTime();
        OkBuffer skipBuffer = new OkBuffer();
        while (TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos) < (long)timeoutMillis) {
            long read2 = in.read(skipBuffer, 2048L);
            if (read2 == -1L) {
                return true;
            }
            skipBuffer.clear();
        }
        return false;
    }

    public static int copy(InputStream in, OutputStream out) throws IOException {
        int c;
        int total = 0;
        byte[] buffer = new byte[8192];
        while ((c = in.read(buffer)) != -1) {
            total += c;
            out.write(buffer, 0, c);
        }
        return total;
    }

    public static String hash(String s2) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] md5bytes = messageDigest.digest(s2.getBytes("UTF-8"));
            return ByteString.of(md5bytes).hex();
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static <T> List<T> immutableList(List<T> list2) {
        return Collections.unmodifiableList(new ArrayList<T>(list2));
    }

    public static <T> List<T> immutableList(T[] elements) {
        return Collections.unmodifiableList(Arrays.asList((Object[])elements.clone()));
    }

    public static ThreadFactory threadFactory(final String name, final boolean daemon) {
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread result2 = new Thread(runnable, name);
                result2.setDaemon(daemon);
                return result2;
            }
        };
    }

    public static List<Header> headerEntries(String ... elements) {
        ArrayList<Header> result2 = new ArrayList<Header>(elements.length / 2);
        for (int i = 0; i < elements.length; i += 2) {
            result2.add(new Header(elements[i], elements[i + 1]));
        }
        return result2;
    }

    public static Protocol getProtocol(ByteString input2) throws IOException {
        if (input2 == null) {
            return Protocol.HTTP_11;
        }
        for (Protocol protocol : Protocol.values()) {
            if (!protocol.name.equals(input2)) continue;
            return protocol;
        }
        throw new IOException("Unexpected protocol: " + input2.utf8());
    }
}

