/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.http;

public final class HeaderParser {
    public static int skipUntil(String input2, int pos, String characters2) {
        while (pos < input2.length() && characters2.indexOf(input2.charAt(pos)) == -1) {
            ++pos;
        }
        return pos;
    }

    public static int skipWhitespace(String input2, int pos) {
        char c;
        while (pos < input2.length() && ((c = input2.charAt(pos)) == ' ' || c == '\t')) {
            ++pos;
        }
        return pos;
    }

    public static int parseSeconds(String value2) {
        try {
            long seconds = Long.parseLong(value2);
            if (seconds > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            if (seconds < 0L) {
                return 0;
            }
            return (int)seconds;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private HeaderParser() {
    }
}

