/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.http;

import com.squareup.okhttp.OkAuthenticator;
import com.squareup.okhttp.internal.http.HeaderParser;
import com.squareup.okhttp.internal.http.Headers;
import com.squareup.okhttp.internal.http.Request;
import com.squareup.okhttp.internal.http.Response;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public final class HttpAuthenticator {
    public static final OkAuthenticator SYSTEM_DEFAULT = new OkAuthenticator(){

        @Override
        public OkAuthenticator.Credential authenticate(Proxy proxy, URL url, List<OkAuthenticator.Challenge> challenges) throws IOException {
            int size2 = challenges.size();
            for (int i = 0; i < size2; ++i) {
                PasswordAuthentication auth;
                OkAuthenticator.Challenge challenge = challenges.get(i);
                if (!"Basic".equalsIgnoreCase(challenge.getScheme()) || (auth = Authenticator.requestPasswordAuthentication(url.getHost(), this.getConnectToInetAddress(proxy, url), url.getPort(), url.getProtocol(), challenge.getRealm(), challenge.getScheme(), url, Authenticator.RequestorType.SERVER)) == null) continue;
                return OkAuthenticator.Credential.basic(auth.getUserName(), new String(auth.getPassword()));
            }
            return null;
        }

        @Override
        public OkAuthenticator.Credential authenticateProxy(Proxy proxy, URL url, List<OkAuthenticator.Challenge> challenges) throws IOException {
            int size2 = challenges.size();
            for (int i = 0; i < size2; ++i) {
                InetSocketAddress proxyAddress;
                PasswordAuthentication auth;
                OkAuthenticator.Challenge challenge = challenges.get(i);
                if (!"Basic".equalsIgnoreCase(challenge.getScheme()) || (auth = Authenticator.requestPasswordAuthentication((proxyAddress = (InetSocketAddress)proxy.address()).getHostName(), this.getConnectToInetAddress(proxy, url), proxyAddress.getPort(), url.getProtocol(), challenge.getRealm(), challenge.getScheme(), url, Authenticator.RequestorType.PROXY)) == null) continue;
                return OkAuthenticator.Credential.basic(auth.getUserName(), new String(auth.getPassword()));
            }
            return null;
        }

        private InetAddress getConnectToInetAddress(Proxy proxy, URL url) throws IOException {
            return proxy != null && proxy.type() != Proxy.Type.DIRECT ? ((InetSocketAddress)proxy.address()).getAddress() : InetAddress.getByName(url.getHost());
        }
    };

    private HttpAuthenticator() {
    }

    public static Request processAuthHeader(OkAuthenticator authenticator, Response response, Proxy proxy) throws IOException {
        OkAuthenticator.Credential credential;
        String requestField;
        String responseField;
        if (response.code() == 401) {
            responseField = "WWW-Authenticate";
            requestField = "Authorization";
        } else if (response.code() == 407) {
            responseField = "Proxy-Authenticate";
            requestField = "Proxy-Authorization";
        } else {
            throw new IllegalArgumentException();
        }
        List<OkAuthenticator.Challenge> challenges = HttpAuthenticator.parseChallenges(response.headers(), responseField);
        if (challenges.isEmpty()) {
            return null;
        }
        Request request = response.request();
        OkAuthenticator.Credential credential2 = credential = response.code() == 407 ? authenticator.authenticateProxy(proxy, request.url(), challenges) : authenticator.authenticate(proxy, request.url(), challenges);
        if (credential == null) {
            return null;
        }
        return request.newBuilder().header(requestField, credential.getHeaderValue()).build();
    }

    private static List<OkAuthenticator.Challenge> parseChallenges(Headers responseHeaders, String challengeHeader) {
        ArrayList<OkAuthenticator.Challenge> result2 = new ArrayList<OkAuthenticator.Challenge>();
        block0: for (int h = 0; h < responseHeaders.size(); ++h) {
            if (!challengeHeader.equalsIgnoreCase(responseHeaders.name(h))) continue;
            String value2 = responseHeaders.value(h);
            int pos = 0;
            while (pos < value2.length()) {
                int tokenStart = pos;
                pos = HeaderParser.skipUntil(value2, pos, " ");
                String scheme = value2.substring(tokenStart, pos).trim();
                if (!value2.regionMatches(true, pos = HeaderParser.skipWhitespace(value2, pos), "realm=\"", 0, "realm=\"".length())) continue block0;
                int realmStart = pos += "realm=\"".length();
                pos = HeaderParser.skipUntil(value2, pos, "\"");
                String realm = value2.substring(realmStart, pos);
                ++pos;
                pos = HeaderParser.skipUntil(value2, pos, ",");
                ++pos;
                pos = HeaderParser.skipWhitespace(value2, pos);
                result2.add(new OkAuthenticator.Challenge(scheme, realm));
            }
        }
        return result2;
    }
}

