/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.http;

import com.squareup.okhttp.CacheControl;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.internal.Platform;
import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.http.Headers;
import com.squareup.okhttp.internal.okio.BufferedSink;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;

public final class Request {
    private final URL url;
    private final String method;
    private final Headers headers;
    private final Body body;
    private final Object tag;
    private volatile ParsedHeaders parsedHeaders;
    private volatile URI uri;
    private volatile CacheControl cacheControl;

    private Request(Builder builder) {
        this.url = builder.url;
        this.method = builder.method;
        this.headers = builder.headers.build();
        this.body = builder.body;
        this.tag = builder.tag != null ? builder.tag : this;
    }

    public URL url() {
        return this.url;
    }

    public URI uri() throws IOException {
        try {
            URI result2 = this.uri;
            return result2 != null ? result2 : (this.uri = Platform.get().toUriLenient(this.url));
        }
        catch (URISyntaxException e) {
            throw new IOException(e.getMessage());
        }
    }

    public String urlString() {
        return this.url.toString();
    }

    public String method() {
        return this.method;
    }

    public Headers headers() {
        return this.headers;
    }

    public String header(String name) {
        return this.headers.get(name);
    }

    public List<String> headers(String name) {
        return this.headers.values(name);
    }

    public Body body() {
        return this.body;
    }

    public Object tag() {
        return this.tag;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public String getUserAgent() {
        return this.parsedHeaders().userAgent;
    }

    public String getProxyAuthorization() {
        return this.parsedHeaders().proxyAuthorization;
    }

    private ParsedHeaders parsedHeaders() {
        ParsedHeaders result2 = this.parsedHeaders;
        return result2 != null ? result2 : (this.parsedHeaders = new ParsedHeaders(this.headers));
    }

    public CacheControl cacheControl() {
        CacheControl result2 = this.cacheControl;
        return result2 != null ? result2 : (this.cacheControl = CacheControl.parse(this.headers));
    }

    public boolean isHttps() {
        return this.url().getProtocol().equals("https");
    }

    public static class Builder {
        private URL url;
        private String method;
        private Headers.Builder headers;
        private Body body;
        private Object tag;

        public Builder() {
            this.method = "GET";
            this.headers = new Headers.Builder();
        }

        private Builder(Request request) {
            this.url = request.url;
            this.method = request.method;
            this.body = request.body;
            this.tag = request.tag;
            this.headers = request.headers.newBuilder();
        }

        public Builder url(String url) {
            try {
                return this.url(new URL(url));
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Malformed URL: " + url);
            }
        }

        public Builder url(URL url) {
            if (url == null) {
                throw new IllegalArgumentException("url == null");
            }
            this.url = url;
            return this;
        }

        public Builder header(String name, String value2) {
            this.headers.set(name, value2);
            return this;
        }

        public Builder addHeader(String name, String value2) {
            this.headers.add(name, value2);
            return this;
        }

        public Builder removeHeader(String name) {
            this.headers.removeAll(name);
            return this;
        }

        public Builder headers(Headers headers) {
            this.headers = headers.newBuilder();
            return this;
        }

        public Builder setUserAgent(String userAgent) {
            return this.header("User-Agent", userAgent);
        }

        public Builder get() {
            return this.method("GET", null);
        }

        public Builder head() {
            return this.method("HEAD", null);
        }

        public Builder post(Body body) {
            return this.method("POST", body);
        }

        public Builder put(Body body) {
            return this.method("PUT", body);
        }

        public Builder method(String method, Body body) {
            if (method == null || method.length() == 0) {
                throw new IllegalArgumentException("method == null || method.length() == 0");
            }
            this.method = method;
            this.body = body;
            return this;
        }

        public Builder tag(Object tag) {
            this.tag = tag;
            return this;
        }

        public Request build() {
            if (this.url == null) {
                throw new IllegalStateException("url == null");
            }
            return new Request(this);
        }
    }

    public static abstract class Body {
        public abstract MediaType contentType();

        public long contentLength() {
            return -1L;
        }

        public abstract void writeTo(BufferedSink var1) throws IOException;

        public static Body create(MediaType contentType, String content) {
            contentType = contentType.charset() != null ? contentType : MediaType.parse(contentType + "; charset=utf-8");
            try {
                byte[] bytes = content.getBytes(contentType.charset().name());
                return Body.create(contentType, bytes);
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError();
            }
        }

        public static Body create(final MediaType contentType, final byte[] content) {
            if (contentType == null) {
                throw new NullPointerException("contentType == null");
            }
            if (content == null) {
                throw new NullPointerException("content == null");
            }
            return new Body(){

                @Override
                public MediaType contentType() {
                    return contentType;
                }

                @Override
                public long contentLength() {
                    return content.length;
                }

                @Override
                public void writeTo(BufferedSink sink) throws IOException {
                    sink.write(content);
                }
            };
        }

        public static Body create(final MediaType contentType, final File file) {
            if (contentType == null) {
                throw new NullPointerException("contentType == null");
            }
            if (file == null) {
                throw new NullPointerException("content == null");
            }
            return new Body(){

                @Override
                public MediaType contentType() {
                    return contentType;
                }

                @Override
                public long contentLength() {
                    return file.length();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void writeTo(BufferedSink sink) throws IOException {
                    long length = this.contentLength();
                    if (length == 0L) {
                        return;
                    }
                    FileInputStream in = null;
                    try {
                        int c;
                        in = new FileInputStream(file);
                        byte[] buffer = new byte[(int)Math.min(8192L, length)];
                        while ((c = ((InputStream)in).read(buffer)) != -1) {
                            sink.write(buffer, 0, c);
                        }
                    }
                    catch (Throwable throwable) {
                        Util.closeQuietly(in);
                        throw throwable;
                    }
                    Util.closeQuietly(in);
                }
            };
        }
    }

    private static class ParsedHeaders {
        private String userAgent;
        private String proxyAuthorization;

        public ParsedHeaders(Headers headers) {
            for (int i = 0; i < headers.size(); ++i) {
                String fieldName = headers.name(i);
                String value2 = headers.value(i);
                if ("User-Agent".equalsIgnoreCase(fieldName)) {
                    this.userAgent = value2;
                    continue;
                }
                if (!"Proxy-Authorization".equalsIgnoreCase(fieldName)) continue;
                this.proxyAuthorization = value2;
            }
        }
    }
}

