/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.http;

import com.squareup.okhttp.internal.http.Request;
import java.net.Proxy;
import java.net.URL;

public final class RequestLine {
    private RequestLine() {
    }

    static String get(Request request, Proxy.Type proxyType, int httpMinorVersion) {
        StringBuilder result2 = new StringBuilder();
        result2.append(request.method());
        result2.append(" ");
        if (RequestLine.includeAuthorityInRequestLine(request, proxyType)) {
            result2.append(request.url());
        } else {
            result2.append(RequestLine.requestPath(request.url()));
        }
        result2.append(" ");
        result2.append(RequestLine.version(httpMinorVersion));
        return result2.toString();
    }

    private static boolean includeAuthorityInRequestLine(Request request, Proxy.Type proxyType) {
        return !request.isHttps() && proxyType == Proxy.Type.HTTP;
    }

    public static String requestPath(URL url) {
        String pathAndQuery = url.getFile();
        if (pathAndQuery == null) {
            return "/";
        }
        if (!pathAndQuery.startsWith("/")) {
            return "/" + pathAndQuery;
        }
        return pathAndQuery;
    }

    public static String version(int httpMinorVersion) {
        return httpMinorVersion == 1 ? "HTTP/1.1" : "HTTP/1.0";
    }
}

