/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.http;

import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.okio.BufferedSink;
import com.squareup.okhttp.internal.okio.Deadline;
import com.squareup.okhttp.internal.okio.OkBuffer;
import com.squareup.okhttp.internal.okio.Sink;
import java.io.IOException;
import java.net.ProtocolException;

final class RetryableSink
implements Sink {
    private boolean closed;
    private final int limit;
    private final OkBuffer content = new OkBuffer();

    public RetryableSink(int limit) {
        this.limit = limit;
    }

    public RetryableSink() {
        this(-1);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.content.size() < (long)this.limit) {
            throw new ProtocolException("content-length promised " + this.limit + " bytes, but received " + this.content.size());
        }
    }

    @Override
    public void write(OkBuffer source, long byteCount) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        Util.checkOffsetAndCount(source.size(), 0L, byteCount);
        if (this.limit != -1 && this.content.size() > (long)this.limit - byteCount) {
            throw new ProtocolException("exceeded content-length limit of " + this.limit + " bytes");
        }
        this.content.write(source, byteCount);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public Sink deadline(Deadline deadline) {
        return this;
    }

    public long contentLength() throws IOException {
        return this.content.size();
    }

    public void writeToSocket(BufferedSink socketOut) throws IOException {
        socketOut.write(this.content.clone(), this.content.size());
    }
}

